#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Eets Munchies
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241103.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='eets-munchies'
GAME_NAME='Eets Munchies'

ARCHIVE_BASE_32BIT_0_NAME='eets2-32x_linux_1394496804.tar'
ARCHIVE_BASE_32BIT_0_MD5='cdbae24ea2579ff9169f2b3d68be8a09'
ARCHIVE_BASE_32BIT_0_SIZE='740000'
ARCHIVE_BASE_32BIT_0_VERSION='1.0-humble.2014.03.10'
ARCHIVE_BASE_32BIT_0_URL='https://www.humblebundle.com/store/eets-munchies'

ARCHIVE_BASE_64BIT_0_NAME='eets2-64x_linux_1394496804.tar'
ARCHIVE_BASE_64BIT_0_MD5='ee7694ca24aabb4c3890123f8cb2474e'
ARCHIVE_BASE_64BIT_0_SIZE='740000'
ARCHIVE_BASE_64BIT_0_VERSION='1.0-humble.2014.03.10'
ARCHIVE_BASE_64BIT_0_URL='https://www.humblebundle.com/store/eets-munchies'

CONTENT_PATH_DEFAULT='eets2'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/bin/lib"
CONTENT_LIBS_BIN_FILES_32BIT='
libfmodevent.so
libfmodevent-4.44.18.so
libfmodex.so
libfmodex-4.44.18.so'
CONTENT_LIBS_BIN_FILES_64BIT='
libfmodevent64.so
libfmodevent64-4.44.18.so
libfmodex64.so
libfmodex64-4.44.18.so'
CONTENT_GAME_BIN_FILES='
bin/eets2-bin'
CONTENT_GAME_DATA_FILES='
Data
*.json
*.kwad
*.lua
*.png
*.xpm'

APP_MAIN_EXE='bin/eets2-bin'
APP_MAIN_ICON='eets2.xpm'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH_32BIT='32'
PKG_BIN_ARCH_64BIT='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
