// { dg-do run }
// { dg-additional-options -DMEM_SHARED { target offload_device_shared_as } }

#include <stdlib.h>
#include <time.h>
#include <bitset>
#include <set>
#include <algorithm>

#define N 4000
#define MAX 16384

void init (int data[])
{
  std::set<int> _set;
  for (int i = 0; i < N; ++i)
    {
      // Avoid duplicates in data array.
      do
	data[i] = rand () % MAX;
      while (_set.find (data[i]) != _set.end ());
      _set.insert (data[i]);
    }
}

bool validate (int sum, int data[])
{
  int total = 0;
  for (int i = 0; i < N; ++i)
    total += data[i];
  return sum == total;
}

int main (void)
{
  int data[N];
  std::bitset<MAX> _set;
  int sum = 0;

  srand (time (NULL));
  init (data);

#ifndef MEM_SHARED
  #pragma omp target data map (to: data[ :N]) map (alloc: _set)
#endif
    {
      #pragma omp target
	{
#ifndef MEM_SHARED
	  new (&_set) std::bitset<MAX> ();
#endif
	  for (int i = 0; i < N; ++i)
	    _set[data[i]] = true;
	}

      #pragma omp target teams distribute parallel for reduction (+:sum)
	for (int i = 0; i < MAX; ++i)
	  if (_set[i])
	    sum += i;

#ifdef OMP_USM
	/* (By construction) we're not allocating memory during device
	   execution, so have nothing to clean up.  */
#endif
#ifndef MEM_SHARED
      #pragma omp target
	_set.~bitset ();
#endif
    }

  bool ok = validate (sum, data);
  return ok ? 0 : 1;
}
