//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// RoleAssignmentsServer is a fake server for instances of the armbilling.RoleAssignmentsClient type.
type RoleAssignmentsServer struct {
	// DeleteByBillingAccount is the fake for method RoleAssignmentsClient.DeleteByBillingAccount
	// HTTP status codes to indicate success: http.StatusOK
	DeleteByBillingAccount func(ctx context.Context, billingAccountName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientDeleteByBillingAccountOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientDeleteByBillingAccountResponse], errResp azfake.ErrorResponder)

	// DeleteByBillingProfile is the fake for method RoleAssignmentsClient.DeleteByBillingProfile
	// HTTP status codes to indicate success: http.StatusOK
	DeleteByBillingProfile func(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientDeleteByBillingProfileOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientDeleteByBillingProfileResponse], errResp azfake.ErrorResponder)

	// DeleteByInvoiceSection is the fake for method RoleAssignmentsClient.DeleteByInvoiceSection
	// HTTP status codes to indicate success: http.StatusOK
	DeleteByInvoiceSection func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientDeleteByInvoiceSectionOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientDeleteByInvoiceSectionResponse], errResp azfake.ErrorResponder)

	// GetByBillingAccount is the fake for method RoleAssignmentsClient.GetByBillingAccount
	// HTTP status codes to indicate success: http.StatusOK
	GetByBillingAccount func(ctx context.Context, billingAccountName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientGetByBillingAccountOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientGetByBillingAccountResponse], errResp azfake.ErrorResponder)

	// GetByBillingProfile is the fake for method RoleAssignmentsClient.GetByBillingProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetByBillingProfile func(ctx context.Context, billingAccountName string, billingProfileName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientGetByBillingProfileOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientGetByBillingProfileResponse], errResp azfake.ErrorResponder)

	// GetByInvoiceSection is the fake for method RoleAssignmentsClient.GetByInvoiceSection
	// HTTP status codes to indicate success: http.StatusOK
	GetByInvoiceSection func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, billingRoleAssignmentName string, options *armbilling.RoleAssignmentsClientGetByInvoiceSectionOptions) (resp azfake.Responder[armbilling.RoleAssignmentsClientGetByInvoiceSectionResponse], errResp azfake.ErrorResponder)

	// NewListByBillingAccountPager is the fake for method RoleAssignmentsClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, options *armbilling.RoleAssignmentsClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method RoleAssignmentsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.RoleAssignmentsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingProfileResponse])

	// NewListByInvoiceSectionPager is the fake for method RoleAssignmentsClient.NewListByInvoiceSectionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInvoiceSectionPager func(billingAccountName string, billingProfileName string, invoiceSectionName string, options *armbilling.RoleAssignmentsClientListByInvoiceSectionOptions) (resp azfake.PagerResponder[armbilling.RoleAssignmentsClientListByInvoiceSectionResponse])
}

// NewRoleAssignmentsServerTransport creates a new instance of RoleAssignmentsServerTransport with the provided implementation.
// The returned RoleAssignmentsServerTransport instance is connected to an instance of armbilling.RoleAssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRoleAssignmentsServerTransport(srv *RoleAssignmentsServer) *RoleAssignmentsServerTransport {
	return &RoleAssignmentsServerTransport{
		srv:                          srv,
		newListByBillingAccountPager: newTracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingAccountResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingProfileResponse]](),
		newListByInvoiceSectionPager: newTracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByInvoiceSectionResponse]](),
	}
}

// RoleAssignmentsServerTransport connects instances of armbilling.RoleAssignmentsClient to instances of RoleAssignmentsServer.
// Don't use this type directly, use NewRoleAssignmentsServerTransport instead.
type RoleAssignmentsServerTransport struct {
	srv                          *RoleAssignmentsServer
	newListByBillingAccountPager *tracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingAccountResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByBillingProfileResponse]]
	newListByInvoiceSectionPager *tracker[azfake.PagerResponder[armbilling.RoleAssignmentsClientListByInvoiceSectionResponse]]
}

// Do implements the policy.Transporter interface for RoleAssignmentsServerTransport.
func (r *RoleAssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RoleAssignmentsClient.DeleteByBillingAccount":
		resp, err = r.dispatchDeleteByBillingAccount(req)
	case "RoleAssignmentsClient.DeleteByBillingProfile":
		resp, err = r.dispatchDeleteByBillingProfile(req)
	case "RoleAssignmentsClient.DeleteByInvoiceSection":
		resp, err = r.dispatchDeleteByInvoiceSection(req)
	case "RoleAssignmentsClient.GetByBillingAccount":
		resp, err = r.dispatchGetByBillingAccount(req)
	case "RoleAssignmentsClient.GetByBillingProfile":
		resp, err = r.dispatchGetByBillingProfile(req)
	case "RoleAssignmentsClient.GetByInvoiceSection":
		resp, err = r.dispatchGetByInvoiceSection(req)
	case "RoleAssignmentsClient.NewListByBillingAccountPager":
		resp, err = r.dispatchNewListByBillingAccountPager(req)
	case "RoleAssignmentsClient.NewListByBillingProfilePager":
		resp, err = r.dispatchNewListByBillingProfilePager(req)
	case "RoleAssignmentsClient.NewListByInvoiceSectionPager":
		resp, err = r.dispatchNewListByInvoiceSectionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchDeleteByBillingAccount(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteByBillingAccount == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByBillingAccount not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteByBillingAccount(req.Context(), billingAccountNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchDeleteByBillingProfile(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteByBillingProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByBillingProfile not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteByBillingProfile(req.Context(), billingAccountNameParam, billingProfileNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchDeleteByInvoiceSection(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteByInvoiceSection == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByInvoiceSection not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteByInvoiceSection(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchGetByBillingAccount(req *http.Request) (*http.Response, error) {
	if r.srv.GetByBillingAccount == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByBillingAccount not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetByBillingAccount(req.Context(), billingAccountNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchGetByBillingProfile(req *http.Request) (*http.Response, error) {
	if r.srv.GetByBillingProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByBillingProfile not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetByBillingProfile(req.Context(), billingAccountNameParam, billingProfileNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchGetByInvoiceSection(req *http.Request) (*http.Response, error) {
	if r.srv.GetByInvoiceSection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByInvoiceSection not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments/(?P<billingRoleAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	billingRoleAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingRoleAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetByInvoiceSection(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, billingRoleAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := r.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByBillingAccountPager(billingAccountNameParam, nil)
		newListByBillingAccountPager = &resp
		r.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.RoleAssignmentsClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		r.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := r.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, nil)
		newListByBillingProfilePager = &resp
		r.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.RoleAssignmentsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		r.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}

func (r *RoleAssignmentsServerTransport) dispatchNewListByInvoiceSectionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByInvoiceSectionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInvoiceSectionPager not implemented")}
	}
	newListByInvoiceSectionPager := r.newListByInvoiceSectionPager.get(req)
	if newListByInvoiceSectionPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingRoleAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByInvoiceSectionPager(billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, nil)
		newListByInvoiceSectionPager = &resp
		r.newListByInvoiceSectionPager.add(req, newListByInvoiceSectionPager)
		server.PagerResponderInjectNextLinks(newListByInvoiceSectionPager, req, func(page *armbilling.RoleAssignmentsClientListByInvoiceSectionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInvoiceSectionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByInvoiceSectionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInvoiceSectionPager) {
		r.newListByInvoiceSectionPager.remove(req)
	}
	return resp, nil
}
