//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcustomerinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerinsights/armcustomerinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsCreateOrUpdate.json
func ExamplePredictionsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPredictionsClient().BeginCreateOrUpdate(ctx, "TestHubRG", "sdkTestHub", "sdktest", armcustomerinsights.PredictionResourceFormat{
		Properties: &armcustomerinsights.Prediction{
			Description: map[string]*string{
				"en-us": to.Ptr("sdktest"),
			},
			AutoAnalyze: to.Ptr(true),
			DisplayName: map[string]*string{
				"en-us": to.Ptr("sdktest"),
			},
			Grades:                   []*armcustomerinsights.PredictionGradesItem{},
			InvolvedInteractionTypes: []*string{},
			InvolvedKpiTypes:         []*string{},
			InvolvedRelationships:    []*string{},
			Mappings: &armcustomerinsights.PredictionMappings{
				Grade:  to.Ptr("sdktest_Grade"),
				Reason: to.Ptr("sdktest_Reason"),
				Score:  to.Ptr("sdktest_Score"),
			},
			NegativeOutcomeExpression: to.Ptr("Customers.FirstName = 'Mike'"),
			PositiveOutcomeExpression: to.Ptr("Customers.FirstName = 'David'"),
			PredictionName:            to.Ptr("sdktest"),
			PrimaryProfileType:        to.Ptr("Customers"),
			ScopeExpression:           to.Ptr("*"),
			ScoreLabel:                to.Ptr("score label"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PredictionResourceFormat = armcustomerinsights.PredictionResourceFormat{
	// 	Name: to.Ptr("sdkTestHub/sdktest"),
	// 	Type: to.Ptr("Microsoft.CustomerInsights/hubs/predictions"),
	// 	ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/predictions/sdktest"),
	// 	Properties: &armcustomerinsights.Prediction{
	// 		Description: map[string]*string{
	// 			"en-us": to.Ptr("sdktest"),
	// 		},
	// 		AutoAnalyze: to.Ptr(true),
	// 		DisplayName: map[string]*string{
	// 			"en-us": to.Ptr("sdktest"),
	// 		},
	// 		Grades: []*armcustomerinsights.PredictionGradesItem{
	// 		},
	// 		InvolvedInteractionTypes: []*string{
	// 		},
	// 		InvolvedKpiTypes: []*string{
	// 		},
	// 		InvolvedRelationships: []*string{
	// 		},
	// 		Mappings: &armcustomerinsights.PredictionMappings{
	// 			Grade: to.Ptr("sdktest_Grade"),
	// 			Reason: to.Ptr("sdktest_Reason"),
	// 			Score: to.Ptr("sdktest_Score"),
	// 		},
	// 		NegativeOutcomeExpression: to.Ptr("Customers.FirstName = 'Mike'"),
	// 		PositiveOutcomeExpression: to.Ptr("Customers.FirstName = 'David'"),
	// 		PredictionName: to.Ptr("sdktest"),
	// 		PrimaryProfileType: to.Ptr("Customers"),
	// 		ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
	// 		ScopeExpression: to.Ptr("*"),
	// 		ScoreLabel: to.Ptr("score label"),
	// 		SystemGeneratedEntities: &armcustomerinsights.PredictionSystemGeneratedEntities{
	// 			GeneratedInteractionTypes: []*string{
	// 				to.Ptr("_predictions_sdktest")},
	// 				GeneratedKpis: map[string]*string{
	// 					"leadingProfiles": to.Ptr("_predictions_sdktest_LeadingProfiles"),
	// 					"negativeOutcomeByGrade": to.Ptr("_predictions_sdktest_NegativeOutcomeByGrade"),
	// 					"positiveOutcomeByGrade": to.Ptr("_predictions_sdktest_PositiveOutcomeByGrade"),
	// 					"predictionPerformance": to.Ptr("_predictions_sdktest_PredictionPerformance"),
	// 				},
	// 				GeneratedLinks: []*string{
	// 					to.Ptr("_predictions_link_sdktest")},
	// 				},
	// 				TenantID: to.Ptr("predtest620"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsGet.json
func ExamplePredictionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPredictionsClient().Get(ctx, "TestHubRG", "sdkTestHub", "sdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PredictionResourceFormat = armcustomerinsights.PredictionResourceFormat{
	// 	Name: to.Ptr("sdkTestHub/sdktest"),
	// 	Type: to.Ptr("Microsoft.CustomerInsights/hubs/predictions"),
	// 	ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/predictions/sdktest"),
	// 	Properties: &armcustomerinsights.Prediction{
	// 		Description: map[string]*string{
	// 			"en-us": to.Ptr("sdktest"),
	// 		},
	// 		AutoAnalyze: to.Ptr(true),
	// 		DisplayName: map[string]*string{
	// 			"en-us": to.Ptr("sdktest"),
	// 		},
	// 		Grades: []*armcustomerinsights.PredictionGradesItem{
	// 		},
	// 		InvolvedInteractionTypes: []*string{
	// 		},
	// 		InvolvedKpiTypes: []*string{
	// 		},
	// 		InvolvedRelationships: []*string{
	// 		},
	// 		Mappings: &armcustomerinsights.PredictionMappings{
	// 			Grade: to.Ptr("sdktest_Grade"),
	// 			Reason: to.Ptr("sdktest_Reason"),
	// 			Score: to.Ptr("sdktest_Score"),
	// 		},
	// 		NegativeOutcomeExpression: to.Ptr("Customers.FirstName = 'Mike'"),
	// 		PositiveOutcomeExpression: to.Ptr("Customers.FirstName = 'David'"),
	// 		PredictionName: to.Ptr("sdktest"),
	// 		PrimaryProfileType: to.Ptr("Customers"),
	// 		ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
	// 		ScopeExpression: to.Ptr("*"),
	// 		ScoreLabel: to.Ptr("score label"),
	// 		SystemGeneratedEntities: &armcustomerinsights.PredictionSystemGeneratedEntities{
	// 			GeneratedInteractionTypes: []*string{
	// 				to.Ptr("_predictions_sdktest")},
	// 				GeneratedKpis: map[string]*string{
	// 					"leadingProfiles": to.Ptr("_predictions_sdktest_LeadingProfiles"),
	// 					"negativeOutcomeByGrade": to.Ptr("_predictions_sdktest_NegativeOutcomeByGrade"),
	// 					"positiveOutcomeByGrade": to.Ptr("_predictions_sdktest_PositiveOutcomeByGrade"),
	// 					"predictionPerformance": to.Ptr("_predictions_sdktest_PredictionPerformance"),
	// 				},
	// 				GeneratedLinks: []*string{
	// 					to.Ptr("_predictions_link_sdktest")},
	// 				},
	// 				TenantID: to.Ptr("predtest620"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsDelete.json
func ExamplePredictionsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPredictionsClient().BeginDelete(ctx, "TestHubRG", "sdkTestHub", "sdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsGetTrainingResults.json
func ExamplePredictionsClient_GetTrainingResults() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPredictionsClient().GetTrainingResults(ctx, "TestHubRG", "sdkTestHub", "sdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PredictionTrainingResults = armcustomerinsights.PredictionTrainingResults{
	// 	CanonicalProfiles: []*armcustomerinsights.CanonicalProfileDefinition{
	// 		{
	// 			CanonicalProfileID: to.Ptr[int32](100),
	// 			Properties: []*armcustomerinsights.CanonicalProfileDefinitionPropertiesItem{
	// 				{
	// 					Type: to.Ptr(armcustomerinsights.CanonicalPropertyValueTypeNumeric),
	// 					ProfileName: to.Ptr("Customers"),
	// 					ProfilePropertyName: to.Ptr("MobilePhone"),
	// 					Rank: to.Ptr[int32](1),
	// 					Value: to.Ptr("139162668.0000 - 34325747410.0000"),
	// 				},
	// 				{
	// 					Type: to.Ptr(armcustomerinsights.CanonicalPropertyValueTypeNumeric),
	// 					ProfileName: to.Ptr("Customers"),
	// 					ProfilePropertyName: to.Ptr("CustomerId"),
	// 					Rank: to.Ptr[int32](2),
	// 					Value: to.Ptr("592266139745.0000 - 592266139864.0000"),
	// 			}},
	// 	}},
	// 	PredictionDistribution: &armcustomerinsights.PredictionDistributionDefinition{
	// 		Distributions: []*armcustomerinsights.PredictionDistributionDefinitionDistributionsItem{
	// 			{
	// 				Negatives: to.Ptr[int64](0),
	// 				NegativesAboveThreshold: to.Ptr[int64](0),
	// 				Positives: to.Ptr[int64](0),
	// 				PositivesAboveThreshold: to.Ptr[int64](0),
	// 				ScoreThreshold: to.Ptr[int32](0),
	// 			},
	// 			{
	// 				Negatives: to.Ptr[int64](0),
	// 				NegativesAboveThreshold: to.Ptr[int64](0),
	// 				Positives: to.Ptr[int64](0),
	// 				PositivesAboveThreshold: to.Ptr[int64](0),
	// 				ScoreThreshold: to.Ptr[int32](1),
	// 		}},
	// 		TotalNegatives: to.Ptr[int64](0),
	// 		TotalPositives: to.Ptr[int64](0),
	// 	},
	// 	PrimaryProfileInstanceCount: to.Ptr[int64](0),
	// 	ScoreName: to.Ptr("sdktest"),
	// 	TenantID: to.Ptr("sdkTestHub"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsGetModelStatus.json
func ExamplePredictionsClient_GetModelStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPredictionsClient().GetModelStatus(ctx, "TestHubRG", "sdkTestHub", "sdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PredictionModelStatus = armcustomerinsights.PredictionModelStatus{
	// 	ModelVersion: to.Ptr("1.0"),
	// 	PredictionGUIDID: to.Ptr("abe4eb1f-d05a-e711-80c2-0004ffa07bea"),
	// 	PredictionName: to.Ptr("sdktest"),
	// 	Status: to.Ptr(armcustomerinsights.PredictionModelLifeCycleNew),
	// 	TenantID: to.Ptr("sdkTestHub"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsModelStatus.json
func ExamplePredictionsClient_ModelStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPredictionsClient().ModelStatus(ctx, "TestHubRG", "sdkTestHub", "sdktest", armcustomerinsights.PredictionModelStatus{
		Status: to.Ptr(armcustomerinsights.PredictionModelLifeCycleTraining),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/customer-insights/resource-manager/Microsoft.CustomerInsights/stable/2017-04-26/examples/PredictionsListByHub.json
func ExamplePredictionsClient_NewListByHubPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcustomerinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPredictionsClient().NewListByHubPager("TestHubRG", "sdkTestHub", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PredictionListResult = armcustomerinsights.PredictionListResult{
		// 	Value: []*armcustomerinsights.PredictionResourceFormat{
		// 		{
		// 			Name: to.Ptr("sdkTestHub/sdktest"),
		// 			Type: to.Ptr("Microsoft.CustomerInsights/hubs/predictions"),
		// 			ID: to.Ptr("/subscriptions/c909e979-ef71-4def-a970-bc7c154db8c5/resourceGroups/TestHubRG/providers/Microsoft.CustomerInsights/hubs/azSdkTestHub/predictions/sdktest"),
		// 			Properties: &armcustomerinsights.Prediction{
		// 				Description: map[string]*string{
		// 					"en-us": to.Ptr("sdktest"),
		// 				},
		// 				AutoAnalyze: to.Ptr(true),
		// 				DisplayName: map[string]*string{
		// 					"en-us": to.Ptr("sdktest"),
		// 				},
		// 				Grades: []*armcustomerinsights.PredictionGradesItem{
		// 				},
		// 				InvolvedInteractionTypes: []*string{
		// 				},
		// 				InvolvedKpiTypes: []*string{
		// 				},
		// 				InvolvedRelationships: []*string{
		// 				},
		// 				Mappings: &armcustomerinsights.PredictionMappings{
		// 					Grade: to.Ptr("sdktest_Grade"),
		// 					Reason: to.Ptr("sdktest_Reason"),
		// 					Score: to.Ptr("sdktest_Score"),
		// 				},
		// 				NegativeOutcomeExpression: to.Ptr("Customers.FirstName = 'Mike'"),
		// 				PositiveOutcomeExpression: to.Ptr("Customers.FirstName = 'David'"),
		// 				PredictionName: to.Ptr("sdktest"),
		// 				PrimaryProfileType: to.Ptr("Customers"),
		// 				ProvisioningState: to.Ptr(armcustomerinsights.ProvisioningStatesSucceeded),
		// 				ScopeExpression: to.Ptr("*"),
		// 				ScoreLabel: to.Ptr("score label"),
		// 				SystemGeneratedEntities: &armcustomerinsights.PredictionSystemGeneratedEntities{
		// 					GeneratedInteractionTypes: []*string{
		// 						to.Ptr("_predictions_sdktest")},
		// 						GeneratedKpis: map[string]*string{
		// 							"leadingProfiles": to.Ptr("_predictions_sdktest_LeadingProfiles"),
		// 							"negativeOutcomeByGrade": to.Ptr("_predictions_sdktest_NegativeOutcomeByGrade"),
		// 							"positiveOutcomeByGrade": to.Ptr("_predictions_sdktest_PositiveOutcomeByGrade"),
		// 							"predictionPerformance": to.Ptr("_predictions_sdktest_PredictionPerformance"),
		// 						},
		// 						GeneratedLinks: []*string{
		// 							to.Ptr("_predictions_link_sdktest")},
		// 						},
		// 						TenantID: to.Ptr("predtest620"),
		// 					},
		// 			}},
		// 		}
	}
}
