//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmediaservices_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-list-by-lastModified.json
func ExampleContentKeyPoliciesClient_NewListPager_listsContentKeyPoliciesOrderedByLastModified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContentKeyPoliciesClient().NewListPager("contoso", "contosomedia", &armmediaservices.ContentKeyPoliciesClientListOptions{Filter: nil,
		Top:     nil,
		Orderby: to.Ptr("properties/lastModified"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContentKeyPolicyCollection = armmediaservices.ContentKeyPolicyCollection{
		// 	Value: []*armmediaservices.ContentKeyPolicy{
		// 		{
		// 			Name: to.Ptr("PolicyWithPlayReadyOptionAndOpenRestriction"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithPlayReadyOptionAndOpenRestriction"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with one PlayReady option and Open Restriction."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyPlayReadyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"),
		// 							Licenses: []*armmediaservices.ContentKeyPolicyPlayReadyLicense{
		// 								{
		// 									AllowTestDevices: to.Ptr(false),
		// 									ContentKeyLocation: &armmediaservices.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader{
		// 										ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"),
		// 									},
		// 									ContentType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyContentTypeUnspecified),
		// 									LicenseType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyLicenseTypeNonPersistent),
		// 									PlayRight: &armmediaservices.ContentKeyPolicyPlayReadyPlayRight{
		// 										AllowPassingVideoContentToUnknownOutput: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed),
		// 										DigitalVideoOnlyContentRestriction: to.Ptr(false),
		// 										ImageConstraintForAnalogComponentVideoRestriction: to.Ptr(false),
		// 										ImageConstraintForAnalogComputerMonitorRestriction: to.Ptr(false),
		// 									},
		// 									SecurityLevel: to.Ptr(armmediaservices.SecurityLevelSL2000),
		// 							}},
		// 							ResponseCustomData: to.Ptr("testCustomData"),
		// 						},
		// 						PolicyOptionID: to.Ptr("294a833f-f128-48be-9edf-8d1bb5b35ff3"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("a9bacd1d-60f5-4af3-8d2b-cf46ca5c9b04"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PolicyWithMultipleOptions"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithMultipleOptions"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with multiple options."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2015-12-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-02T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
		// 						},
		// 						PolicyOptionID: to.Ptr("caf1e28c-8288-4301-8c46-c0f9312c512f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
		// 							AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
		// 							},
		// 							Audience: to.Ptr("urn:test"),
		// 							Issuer: to.Ptr("http://testacs"),
		// 							PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
		// 								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
		// 								KeyValue: []byte(""),
		// 							},
		// 							RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
		// 								{
		// 									ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
		// 								},
		// 								{
		// 									ClaimType: to.Ptr("DRM"),
		// 									ClaimValue: to.Ptr("Widevine"),
		// 							}},
		// 							RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
		// 						},
		// 					},
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
		// 							WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
		// 						},
		// 						PolicyOptionID: to.Ptr("da346259-0cd6-4609-89dc-15ac131bd92f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("ed7f3d1b-cfa7-4181-b966-e0b3027eec3a"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PolicyWithClearKeyOptionAndTokenRestriction"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithClearKeyOptionAndTokenRestriction"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with one ClearKey option and Open Restriction."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
		// 						},
		// 						PolicyOptionID: to.Ptr("a3448d09-567a-4642-8309-d17e846be59f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
		// 							AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
		// 							},
		// 							Audience: to.Ptr("urn:test"),
		// 							Issuer: to.Ptr("http://testacs"),
		// 							PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
		// 								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
		// 								KeyValue: []byte(""),
		// 							},
		// 							RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
		// 								{
		// 									ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
		// 								},
		// 								{
		// 									ClaimType: to.Ptr("DRM"),
		// 									ClaimValue: to.Ptr("Widevine"),
		// 							}},
		// 							RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("8352435b-ebea-4681-aae7-e19277771f64"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-list-in-date-range.json
func ExampleContentKeyPoliciesClient_NewListPager_listsContentKeyPoliciesWithCreatedAndLastModifiedFilters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContentKeyPoliciesClient().NewListPager("contoso", "contosomedia", &armmediaservices.ContentKeyPoliciesClientListOptions{Filter: to.Ptr("properties/lastModified gt 2016-06-01 and properties/created lt 2013-07-01"),
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContentKeyPolicyCollection = armmediaservices.ContentKeyPolicyCollection{
		// 	Value: []*armmediaservices.ContentKeyPolicy{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-list-all.json
func ExampleContentKeyPoliciesClient_NewListPager_listsAllContentKeyPolicies() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewContentKeyPoliciesClient().NewListPager("contoso", "contosomedia", &armmediaservices.ContentKeyPoliciesClientListOptions{Filter: nil,
		Top:     nil,
		Orderby: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ContentKeyPolicyCollection = armmediaservices.ContentKeyPolicyCollection{
		// 	Value: []*armmediaservices.ContentKeyPolicy{
		// 		{
		// 			Name: to.Ptr("PolicyWithClearKeyOptionAndTokenRestriction"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithClearKeyOptionAndTokenRestriction"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with one ClearKey option and Open Restriction."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-01T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
		// 						},
		// 						PolicyOptionID: to.Ptr("a3448d09-567a-4642-8309-d17e846be59f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
		// 							AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
		// 							},
		// 							Audience: to.Ptr("urn:test"),
		// 							Issuer: to.Ptr("http://testacs"),
		// 							PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
		// 								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
		// 								KeyValue: []byte(""),
		// 							},
		// 							RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
		// 								{
		// 									ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
		// 								},
		// 								{
		// 									ClaimType: to.Ptr("DRM"),
		// 									ClaimValue: to.Ptr("Widevine"),
		// 							}},
		// 							RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("8352435b-ebea-4681-aae7-e19277771f64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PolicyWithMultipleOptions"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithMultipleOptions"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with multiple options."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2015-12-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-02T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
		// 						},
		// 						PolicyOptionID: to.Ptr("caf1e28c-8288-4301-8c46-c0f9312c512f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
		// 							AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
		// 							},
		// 							Audience: to.Ptr("urn:test"),
		// 							Issuer: to.Ptr("http://testacs"),
		// 							PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
		// 								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
		// 								KeyValue: []byte(""),
		// 							},
		// 							RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
		// 								{
		// 									ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
		// 								},
		// 								{
		// 									ClaimType: to.Ptr("DRM"),
		// 									ClaimValue: to.Ptr("Widevine"),
		// 							}},
		// 							RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
		// 						},
		// 					},
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
		// 							WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
		// 						},
		// 						PolicyOptionID: to.Ptr("da346259-0cd6-4609-89dc-15ac131bd92f"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("ed7f3d1b-cfa7-4181-b966-e0b3027eec3a"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PolicyWithPlayReadyOptionAndOpenRestriction"),
		// 			Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithPlayReadyOptionAndOpenRestriction"),
		// 			Properties: &armmediaservices.ContentKeyPolicyProperties{
		// 				Description: to.Ptr("A policy with one PlayReady option and Open Restriction."),
		// 				Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
		// 				Options: []*armmediaservices.ContentKeyPolicyOption{
		// 					{
		// 						Configuration: &armmediaservices.ContentKeyPolicyPlayReadyConfiguration{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"),
		// 							Licenses: []*armmediaservices.ContentKeyPolicyPlayReadyLicense{
		// 								{
		// 									AllowTestDevices: to.Ptr(false),
		// 									ContentKeyLocation: &armmediaservices.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader{
		// 										ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"),
		// 									},
		// 									ContentType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyContentTypeUnspecified),
		// 									LicenseType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyLicenseTypeNonPersistent),
		// 									PlayRight: &armmediaservices.ContentKeyPolicyPlayReadyPlayRight{
		// 										AllowPassingVideoContentToUnknownOutput: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed),
		// 										DigitalVideoOnlyContentRestriction: to.Ptr(false),
		// 										ImageConstraintForAnalogComponentVideoRestriction: to.Ptr(false),
		// 										ImageConstraintForAnalogComputerMonitorRestriction: to.Ptr(false),
		// 									},
		// 									SecurityLevel: to.Ptr(armmediaservices.SecurityLevelSL2000),
		// 							}},
		// 							ResponseCustomData: to.Ptr("testCustomData"),
		// 						},
		// 						PolicyOptionID: to.Ptr("294a833f-f128-48be-9edf-8d1bb5b35ff3"),
		// 						Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
		// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
		// 						},
		// 				}},
		// 				PolicyID: to.Ptr("a9bacd1d-60f5-4af3-8d2b-cf46ca5c9b04"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-get-by-name.json
func ExampleContentKeyPoliciesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().Get(ctx, "contoso", "contosomedia", "PolicyWithMultipleOptions", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyWithMultipleOptions"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithMultipleOptions"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("A policy with multiple options."),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2015-12-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-02T00:00:00.000Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
	// 				},
	// 				PolicyOptionID: to.Ptr("caf1e28c-8288-4301-8c46-c0f9312c512f"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
	// 					AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
	// 					},
	// 					Audience: to.Ptr("urn:test"),
	// 					Issuer: to.Ptr("http://testacs"),
	// 					PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
	// 						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
	// 						KeyValue: []byte(""),
	// 					},
	// 					RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
	// 						{
	// 							ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
	// 						},
	// 						{
	// 							ClaimType: to.Ptr("DRM"),
	// 							ClaimValue: to.Ptr("Widevine"),
	// 					}},
	// 					RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
	// 				},
	// 			},
	// 			{
	// 				Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
	// 					WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
	// 				},
	// 				PolicyOptionID: to.Ptr("da346259-0cd6-4609-89dc-15ac131bd92f"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("ed7f3d1b-cfa7-4181-b966-e0b3027eec3a"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-create-nodrm-token.json
func ExampleContentKeyPoliciesClient_CreateOrUpdate_createsAContentKeyPolicyWithClearKeyOptionAndTokenRestriction() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().CreateOrUpdate(ctx, "contoso", "contosomedia", "PolicyWithClearKeyOptionAndSwtTokenRestriction", armmediaservices.ContentKeyPolicy{
		Properties: &armmediaservices.ContentKeyPolicyProperties{
			Description: to.Ptr("ArmPolicyDescription"),
			Options: []*armmediaservices.ContentKeyPolicyOption{
				{
					Name: to.Ptr("ClearKeyOption"),
					Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
					},
					Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
						Audience:  to.Ptr("urn:audience"),
						Issuer:    to.Ptr("urn:issuer"),
						PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
							KeyValue:  []byte("AAAAAAAAAAAAAAAAAAAAAA=="),
						},
						RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeSwt),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyWithClearKeyOptionAndSwtTokenRestriction"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithClearKeyOptionAndSwtTokenRestriction"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("ArmPolicyDescription"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.837Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.837Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Name: to.Ptr("ClearKeyOption"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
	// 				},
	// 				PolicyOptionID: to.Ptr("e7d4d465-b6f7-4830-9a21-74a7326ef797"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
	// 					AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
	// 					},
	// 					Audience: to.Ptr("urn:audience"),
	// 					Issuer: to.Ptr("urn:issuer"),
	// 					PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
	// 						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
	// 						KeyValue: []byte(""),
	// 					},
	// 					RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
	// 					},
	// 					RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeSwt),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("2926c1bc-4dec-4a11-9d19-3f99006530a9"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-create-playready-open.json
func ExampleContentKeyPoliciesClient_CreateOrUpdate_createsAContentKeyPolicyWithPlayReadyOptionAndOpenRestriction() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().CreateOrUpdate(ctx, "contoso", "contosomedia", "PolicyWithPlayReadyOptionAndOpenRestriction", armmediaservices.ContentKeyPolicy{
		Properties: &armmediaservices.ContentKeyPolicyProperties{
			Description: to.Ptr("ArmPolicyDescription"),
			Options: []*armmediaservices.ContentKeyPolicyOption{
				{
					Name: to.Ptr("ArmPolicyOptionName"),
					Configuration: &armmediaservices.ContentKeyPolicyPlayReadyConfiguration{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"),
						Licenses: []*armmediaservices.ContentKeyPolicyPlayReadyLicense{
							{
								AllowTestDevices: to.Ptr(true),
								BeginDate:        to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-10-16T18:22:53.460Z"); return t }()),
								ContentKeyLocation: &armmediaservices.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader{
									ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"),
								},
								ContentType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload),
								LicenseType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyLicenseTypePersistent),
								PlayRight: &armmediaservices.ContentKeyPolicyPlayReadyPlayRight{
									AllowPassingVideoContentToUnknownOutput:            to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed),
									DigitalVideoOnlyContentRestriction:                 to.Ptr(false),
									ImageConstraintForAnalogComponentVideoRestriction:  to.Ptr(true),
									ImageConstraintForAnalogComputerMonitorRestriction: to.Ptr(false),
									ScmsRestriction: to.Ptr[int32](2),
								},
								SecurityLevel: to.Ptr(armmediaservices.SecurityLevelSL150),
							}},
					},
					Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyWithPlayReadyOptionAndOpenRestriction"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithPlayReadyOptionAndOpenRestriction"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("ArmPolicyDescription"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2012-11-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.510Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Name: to.Ptr("ArmPolicyOptionName"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyPlayReadyConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"),
	// 					Licenses: []*armmediaservices.ContentKeyPolicyPlayReadyLicense{
	// 						{
	// 							AllowTestDevices: to.Ptr(true),
	// 							BeginDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-10-16T18:22:53.460Z"); return t}()),
	// 							ContentKeyLocation: &armmediaservices.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader{
	// 								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"),
	// 							},
	// 							ContentType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload),
	// 							LicenseType: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyLicenseTypePersistent),
	// 							PlayRight: &armmediaservices.ContentKeyPolicyPlayReadyPlayRight{
	// 								AllowPassingVideoContentToUnknownOutput: to.Ptr(armmediaservices.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed),
	// 								DigitalVideoOnlyContentRestriction: to.Ptr(false),
	// 								ImageConstraintForAnalogComponentVideoRestriction: to.Ptr(true),
	// 								ImageConstraintForAnalogComputerMonitorRestriction: to.Ptr(false),
	// 								ScmsRestriction: to.Ptr[int32](2),
	// 							},
	// 							SecurityLevel: to.Ptr(armmediaservices.SecurityLevelSL150),
	// 					}},
	// 				},
	// 				PolicyOptionID: to.Ptr("c52f9af0-1f53-4775-8edb-af2d9a6e28cd"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("a9bacd1d-60f5-4af3-8d2b-cf46ca5c9b04"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-create-widevine-token.json
func ExampleContentKeyPoliciesClient_CreateOrUpdate_createsAContentKeyPolicyWithWidevineOptionAndTokenRestriction() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().CreateOrUpdate(ctx, "contoso", "contosomedia", "PolicyWithWidevineOptionAndJwtTokenRestriction", armmediaservices.ContentKeyPolicy{
		Properties: &armmediaservices.ContentKeyPolicyProperties{
			Description: to.Ptr("ArmPolicyDescription"),
			Options: []*armmediaservices.ContentKeyPolicyOption{
				{
					Name: to.Ptr("widevineoption"),
					Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
						ODataType:        to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
						WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
					},
					Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
						AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
							&armmediaservices.ContentKeyPolicySymmetricTokenKey{
								ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
								KeyValue:  []byte("AAAAAAAAAAAAAAAAAAAAAA=="),
							}},
						Audience: to.Ptr("urn:audience"),
						Issuer:   to.Ptr("urn:issuer"),
						PrimaryVerificationKey: &armmediaservices.ContentKeyPolicyRsaTokenKey{
							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyRsaTokenKey"),
							Exponent:  []byte("AQAB"),
							Modulus:   []byte("AQAD"),
						},
						RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyWithWidevineOptionAndJwtTokenRestriction"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithWidevineOptionAndJwtTokenRestriction"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("ArmPolicyDescription"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.663Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.663Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Name: to.Ptr("widevineoption"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
	// 					WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
	// 				},
	// 				PolicyOptionID: to.Ptr("26fee004-8dfa-4828-bcad-5e63c637534f"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
	// 					AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
	// 						&armmediaservices.ContentKeyPolicySymmetricTokenKey{
	// 							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
	// 							KeyValue: []byte(""),
	// 					}},
	// 					Audience: to.Ptr("urn:audience"),
	// 					Issuer: to.Ptr("urn:issuer"),
	// 					PrimaryVerificationKey: &armmediaservices.ContentKeyPolicyRsaTokenKey{
	// 						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyRsaTokenKey"),
	// 						Exponent: []byte(""),
	// 						Modulus: []byte(""),
	// 					},
	// 					RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
	// 					},
	// 					RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("bad1d030-7d5c-4643-8f1e-49807a4bf64c"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-create-multiple-options.json
func ExampleContentKeyPoliciesClient_CreateOrUpdate_createsAContentKeyPolicyWithMultipleOptions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().CreateOrUpdate(ctx, "contoso", "contosomedia", "PolicyCreatedWithMultipleOptions", armmediaservices.ContentKeyPolicy{
		Properties: &armmediaservices.ContentKeyPolicyProperties{
			Description: to.Ptr("ArmPolicyDescription"),
			Options: []*armmediaservices.ContentKeyPolicyOption{
				{
					Name: to.Ptr("ClearKeyOption"),
					Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
					},
					Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
						Audience:  to.Ptr("urn:audience"),
						Issuer:    to.Ptr("urn:issuer"),
						PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
							ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
							KeyValue:  []byte("AAAAAAAAAAAAAAAAAAAAAA=="),
						},
						RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeSwt),
					},
				},
				{
					Name: to.Ptr("widevineoption"),
					Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
						ODataType:        to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
						WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
					},
					Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyCreatedWithMultipleOptions"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyCreatedWithMultipleOptions"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("ArmPolicyDescription"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.980Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:29.980Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Name: to.Ptr("ClearKeyOption"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
	// 				},
	// 				PolicyOptionID: to.Ptr("8dac9510-770a-401f-8f2b-f72640977ed0"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
	// 					AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
	// 					},
	// 					Audience: to.Ptr("urn:audience"),
	// 					Issuer: to.Ptr("urn:issuer"),
	// 					PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
	// 						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
	// 						KeyValue: []byte(""),
	// 					},
	// 					RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
	// 					},
	// 					RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeSwt),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("widevineoption"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
	// 					WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
	// 				},
	// 				PolicyOptionID: to.Ptr("fc121776-6ced-4135-be92-f928dedc029a"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("07ad673b-dc14-4230-adab-716622f33992"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-delete.json
func ExampleContentKeyPoliciesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewContentKeyPoliciesClient().Delete(ctx, "contoso", "contosomedia", "PolicyWithPlayReadyOptionAndOpenRestriction", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-update.json
func ExampleContentKeyPoliciesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().Update(ctx, "contoso", "contosomedia", "PolicyWithClearKeyOptionAndTokenRestriction", armmediaservices.ContentKeyPolicy{
		Properties: &armmediaservices.ContentKeyPolicyProperties{
			Description: to.Ptr("Updated Policy"),
			Options: []*armmediaservices.ContentKeyPolicyOption{
				{
					Name: to.Ptr("ClearKeyOption"),
					Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
					},
					Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
						ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicy = armmediaservices.ContentKeyPolicy{
	// 	Name: to.Ptr("PolicyWithClearKeyOptionAndTokenRestriction"),
	// 	Type: to.Ptr("Microsoft.Media/mediaservices/contentKeyPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso/providers/Microsoft.Media/mediaservices/contosomedia/contentKeyPolicies/PolicyWithClearKeyOptionAndTokenRestriction"),
	// 	Properties: &armmediaservices.ContentKeyPolicyProperties{
	// 		Description: to.Ptr("Updated Policy"),
	// 		Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-01T00:00:00.000Z"); return t}()),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-08T18:29:30.303Z"); return t}()),
	// 		Options: []*armmediaservices.ContentKeyPolicyOption{
	// 			{
	// 				Name: to.Ptr("ClearKeyOption"),
	// 				Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
	// 				},
	// 				PolicyOptionID: to.Ptr("7d3f4bc1-d2bf-43a3-b02e-a7e31ab15d43"),
	// 				Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
	// 				},
	// 		}},
	// 		PolicyID: to.Ptr("8352435b-ebea-4681-aae7-e19277771f64"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/mediaservices/resource-manager/Microsoft.Media/Metadata/stable/2022-08-01/examples/content-key-policies-get-with-secrets.json
func ExampleContentKeyPoliciesClient_GetPolicyPropertiesWithSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmediaservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewContentKeyPoliciesClient().GetPolicyPropertiesWithSecrets(ctx, "contoso", "contosomedia", "PolicyWithMultipleOptions", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContentKeyPolicyProperties = armmediaservices.ContentKeyPolicyProperties{
	// 	Description: to.Ptr("A policy with multiple options."),
	// 	Created: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2015-12-01T00:00:00.000Z"); return t}()),
	// 	LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-12-02T00:00:00.000Z"); return t}()),
	// 	Options: []*armmediaservices.ContentKeyPolicyOption{
	// 		{
	// 			Configuration: &armmediaservices.ContentKeyPolicyClearKeyConfiguration{
	// 				ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"),
	// 			},
	// 			PolicyOptionID: to.Ptr("caf1e28c-8288-4301-8c46-c0f9312c512f"),
	// 			Restriction: &armmediaservices.ContentKeyPolicyTokenRestriction{
	// 				ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyTokenRestriction"),
	// 				AlternateVerificationKeys: []armmediaservices.ContentKeyPolicyRestrictionTokenKeyClassification{
	// 				},
	// 				Audience: to.Ptr("urn:test"),
	// 				Issuer: to.Ptr("http://testacs"),
	// 				PrimaryVerificationKey: &armmediaservices.ContentKeyPolicySymmetricTokenKey{
	// 					ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"),
	// 					KeyValue: []byte("AAA="),
	// 				},
	// 				RequiredClaims: []*armmediaservices.ContentKeyPolicyTokenClaim{
	// 					{
	// 						ClaimType: to.Ptr("urn:microsoft:azure:mediaservices:contentkeyidentifier"),
	// 					},
	// 					{
	// 						ClaimType: to.Ptr("DRM"),
	// 						ClaimValue: to.Ptr("Widevine"),
	// 				}},
	// 				RestrictionTokenType: to.Ptr(armmediaservices.ContentKeyPolicyRestrictionTokenTypeJwt),
	// 			},
	// 		},
	// 		{
	// 			Configuration: &armmediaservices.ContentKeyPolicyWidevineConfiguration{
	// 				ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"),
	// 				WidevineTemplate: to.Ptr("{\"allowed_track_types\":\"SD_HD\",\"content_key_specs\":[{\"track_type\":\"SD\",\"security_level\":1,\"required_output_protection\":{\"hdcp\":\"HDCP_V2\"}}],\"policy_overrides\":{\"can_play\":true,\"can_persist\":true,\"can_renew\":false}}"),
	// 			},
	// 			PolicyOptionID: to.Ptr("da346259-0cd6-4609-89dc-15ac131bd92f"),
	// 			Restriction: &armmediaservices.ContentKeyPolicyOpenRestriction{
	// 				ODataType: to.Ptr("#Microsoft.Media.ContentKeyPolicyOpenRestriction"),
	// 			},
	// 	}},
	// 	PolicyID: to.Ptr("ed7f3d1b-cfa7-4181-b966-e0b3027eec3a"),
	// }
}
