//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayUpdate.json
func ExampleVirtualNetworkGatewaysClient_BeginCreateOrUpdate_updateVirtualNetworkGateway() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginCreateOrUpdate(ctx, "rg1", "vpngw", armnetwork.VirtualNetworkGateway{
		Location: to.Ptr("centralus"),
		Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
			Active:                 to.Ptr(false),
			AllowRemoteVnetTraffic: to.Ptr(false),
			AllowVirtualWanTraffic: to.Ptr(false),
			BgpSettings: &armnetwork.BgpSettings{
				Asn:               to.Ptr[int64](65515),
				BgpPeeringAddress: to.Ptr("10.0.1.30"),
				PeerWeight:        to.Ptr[int32](0),
			},
			CustomRoutes: &armnetwork.AddressSpace{
				AddressPrefixes: []*string{
					to.Ptr("101.168.0.6/32")},
			},
			DisableIPSecReplayProtection:    to.Ptr(false),
			EnableBgp:                       to.Ptr(false),
			EnableBgpRouteTranslationForNat: to.Ptr(false),
			EnableDNSForwarding:             to.Ptr(true),
			GatewayType:                     to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
			IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
				{
					Name: to.Ptr("gwipconfig1"),
					Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
						PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
						},
					},
				}},
			NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
					Name: to.Ptr("natRule1"),
					Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
						Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
						ExternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("50.0.0.0/24"),
							}},
						InternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("10.10.0.0/24"),
							}},
						IPConfigurationID: to.Ptr(""),
						Mode:              to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
					},
				},
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
					Name: to.Ptr("natRule2"),
					Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
						Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
						ExternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("30.0.0.0/24"),
							}},
						InternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("20.10.0.0/24"),
							}},
						IPConfigurationID: to.Ptr(""),
						Mode:              to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
					},
				}},
			SKU: &armnetwork.VirtualNetworkGatewaySKU{
				Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
				Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
			},
			VPNClientConfiguration: &armnetwork.VPNClientConfiguration{
				RadiusServers: []*armnetwork.RadiusServer{
					{
						RadiusServerAddress: to.Ptr("10.2.0.0"),
						RadiusServerScore:   to.Ptr[int64](20),
						RadiusServerSecret:  to.Ptr("radiusServerSecret"),
					}},
				VPNClientProtocols: []*armnetwork.VPNClientProtocol{
					to.Ptr(armnetwork.VPNClientProtocolOpenVPN)},
				VPNClientRevokedCertificates: []*armnetwork.VPNClientRevokedCertificate{},
				VPNClientRootCertificates:    []*armnetwork.VPNClientRootCertificate{},
			},
			VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("vpngw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
	// 	Location: to.Ptr("centralus"),
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		AllowRemoteVnetTraffic: to.Ptr(false),
	// 		AllowVirtualWanTraffic: to.Ptr(false),
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65515),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.10")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.3.1.254")},
	// 							IPConfigurationID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("52.161.10.135")},
	// 						}},
	// 						PeerWeight: to.Ptr[int32](0),
	// 					},
	// 					CustomRoutes: &armnetwork.AddressSpace{
	// 						AddressPrefixes: []*string{
	// 							to.Ptr("101.168.0.6/32")},
	// 						},
	// 						DisableIPSecReplayProtection: to.Ptr(false),
	// 						EnableBgp: to.Ptr(false),
	// 						EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 						EnableDNSForwarding: to.Ptr(true),
	// 						GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
	// 						InboundDNSForwardingEndpoint: to.Ptr("10.0.1.14"),
	// 						IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 								Name: to.Ptr("gwipconfig1"),
	// 								Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 								Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 									PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									PublicIPAddress: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
	// 									},
	// 									Subnet: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
	// 									},
	// 								},
	// 						}},
	// 						NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
	// 								Name: to.Ptr("natRule1"),
	// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("50.0.0.0/24"),
	// 									}},
	// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("10.10.0.0/24"),
	// 									}},
	// 									IPConfigurationID: to.Ptr(""),
	// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 								},
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
	// 								Name: to.Ptr("natRule2"),
	// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("30.0.0.0/24"),
	// 									}},
	// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("20.10.0.0/24"),
	// 									}},
	// 									IPConfigurationID: to.Ptr(""),
	// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
	// 								},
	// 						}},
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 						SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 							Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
	// 							Capacity: to.Ptr[int32](0),
	// 							Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
	// 						},
	// 						VPNClientConfiguration: &armnetwork.VPNClientConfiguration{
	// 							RadiusServers: []*armnetwork.RadiusServer{
	// 								{
	// 									RadiusServerAddress: to.Ptr("10.2.0.0"),
	// 									RadiusServerScore: to.Ptr[int64](20),
	// 							}},
	// 							VPNClientProtocols: []*armnetwork.VPNClientProtocol{
	// 								to.Ptr(armnetwork.VPNClientProtocolOpenVPN)},
	// 								VPNClientRevokedCertificates: []*armnetwork.VPNClientRevokedCertificate{
	// 								},
	// 								VPNClientRootCertificates: []*armnetwork.VPNClientRootCertificate{
	// 								},
	// 							},
	// 							VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
	// 							VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkScalableGatewayUpdate.json
func ExampleVirtualNetworkGatewaysClient_BeginCreateOrUpdate_updateVirtualNetworkScalableGateway() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginCreateOrUpdate(ctx, "rg1", "ergw", armnetwork.VirtualNetworkGateway{
		Location: to.Ptr("centralus"),
		Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
			Active:                          to.Ptr(false),
			AllowRemoteVnetTraffic:          to.Ptr(false),
			AllowVirtualWanTraffic:          to.Ptr(false),
			DisableIPSecReplayProtection:    to.Ptr(false),
			EnableBgp:                       to.Ptr(false),
			EnableBgpRouteTranslationForNat: to.Ptr(false),
			GatewayType:                     to.Ptr(armnetwork.VirtualNetworkGatewayTypeExpressRoute),
			IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
				{
					Name: to.Ptr("gwipconfig1"),
					Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
						PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodStatic),
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
						},
					},
				}},
			NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule1"),
					Name: to.Ptr("natRule1"),
					Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
						Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
						ExternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("50.0.0.0/24"),
							}},
						InternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("10.10.0.0/24"),
							}},
						IPConfigurationID: to.Ptr(""),
						Mode:              to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
					},
				},
				{
					ID:   to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule2"),
					Name: to.Ptr("natRule2"),
					Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
						Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
						ExternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("30.0.0.0/24"),
							}},
						InternalMappings: []*armnetwork.VPNNatRuleMapping{
							{
								AddressSpace: to.Ptr("20.10.0.0/24"),
							}},
						IPConfigurationID: to.Ptr(""),
						Mode:              to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
					},
				}},
			SKU: &armnetwork.VirtualNetworkGatewaySKU{
				Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUName("ErGwScale")),
				Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTier("ErGwScale")),
			},
			VPNType: to.Ptr(armnetwork.VPNTypePolicyBased),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("ergw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw"),
	// 	Location: to.Ptr("centralus"),
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		AllowRemoteVnetTraffic: to.Ptr(false),
	// 		AllowVirtualWanTraffic: to.Ptr(false),
	// 		AutoScaleConfiguration: &armnetwork.VirtualNetworkGatewayAutoScaleConfiguration{
	// 			Bounds: &armnetwork.VirtualNetworkGatewayAutoScaleBounds{
	// 				Max: to.Ptr[int32](3),
	// 				Min: to.Ptr[int32](2),
	// 			},
	// 		},
	// 		DisableIPSecReplayProtection: to.Ptr(false),
	// 		EnableBgp: to.Ptr(false),
	// 		EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 		GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeExpressRoute),
	// 		IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/ipConfigurations/default"),
	// 				Name: to.Ptr("gwipconfig1"),
	// 				Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 				Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 					PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicIPAddress: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
	// 					},
	// 					Subnet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
	// 					},
	// 				},
	// 		}},
	// 		NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule1"),
	// 				Name: to.Ptr("natRule1"),
	// 				Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 					Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 					ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("50.0.0.0/24"),
	// 					}},
	// 					InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("10.10.0.0/24"),
	// 					}},
	// 					IPConfigurationID: to.Ptr(""),
	// 					Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule2"),
	// 				Name: to.Ptr("natRule2"),
	// 				Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 					Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 					ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("30.0.0.0/24"),
	// 					}},
	// 					InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("20.10.0.0/24"),
	// 					}},
	// 					IPConfigurationID: to.Ptr(""),
	// 					Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 			Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUName("ErGwScale")),
	// 			Capacity: to.Ptr[int32](0),
	// 			Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTier("ErGwScale")),
	// 		},
	// 		VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
	// 		VPNType: to.Ptr(armnetwork.VPNTypePolicyBased),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGet.json
func ExampleVirtualNetworkGatewaysClient_Get_getVirtualNetworkGateway() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualNetworkGatewaysClient().Get(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("vpngw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
	// 	Location: to.Ptr("centralus"),
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		AllowRemoteVnetTraffic: to.Ptr(false),
	// 		AllowVirtualWanTraffic: to.Ptr(false),
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65514),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.10")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.3.1.254")},
	// 							IPConfigurationID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("52.161.10.135")},
	// 						}},
	// 						PeerWeight: to.Ptr[int32](0),
	// 					},
	// 					CustomRoutes: &armnetwork.AddressSpace{
	// 						AddressPrefixes: []*string{
	// 							to.Ptr("101.168.0.6/32")},
	// 						},
	// 						DisableIPSecReplayProtection: to.Ptr(false),
	// 						EnableBgp: to.Ptr(false),
	// 						EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 						EnablePrivateIPAddress: to.Ptr(false),
	// 						GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
	// 						IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 								Name: to.Ptr("gwipconfig1"),
	// 								Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 								Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 									PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									PublicIPAddress: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
	// 									},
	// 									Subnet: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
	// 									},
	// 								},
	// 						}},
	// 						NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
	// 								Name: to.Ptr("natRule1"),
	// 								Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
	// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("50.0.0.0/24"),
	// 									}},
	// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("10.10.0.0/24"),
	// 									}},
	// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 								},
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
	// 								Name: to.Ptr("natRule2"),
	// 								Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
	// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("30.0.0.0/24"),
	// 									}},
	// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 										{
	// 											AddressSpace: to.Ptr("20.10.0.0/24"),
	// 									}},
	// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 								},
	// 						}},
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 						SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 							Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
	// 							Capacity: to.Ptr[int32](0),
	// 							Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
	// 						},
	// 						VPNClientConfiguration: &armnetwork.VPNClientConfiguration{
	// 							RadiusServers: []*armnetwork.RadiusServer{
	// 								{
	// 									RadiusServerAddress: to.Ptr("10.1.0.0"),
	// 									RadiusServerScore: to.Ptr[int64](20),
	// 							}},
	// 							VPNClientProtocols: []*armnetwork.VPNClientProtocol{
	// 								to.Ptr(armnetwork.VPNClientProtocolOpenVPN)},
	// 								VPNClientRevokedCertificates: []*armnetwork.VPNClientRevokedCertificate{
	// 								},
	// 								VPNClientRootCertificates: []*armnetwork.VPNClientRootCertificate{
	// 								},
	// 							},
	// 							VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
	// 							VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkScalableGatewayGet.json
func ExampleVirtualNetworkGatewaysClient_Get_getVirtualNetworkScalableGateway() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualNetworkGatewaysClient().Get(ctx, "rg1", "ergw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("ergw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw"),
	// 	Location: to.Ptr("centralus"),
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		AllowRemoteVnetTraffic: to.Ptr(false),
	// 		AllowVirtualWanTraffic: to.Ptr(false),
	// 		AutoScaleConfiguration: &armnetwork.VirtualNetworkGatewayAutoScaleConfiguration{
	// 			Bounds: &armnetwork.VirtualNetworkGatewayAutoScaleBounds{
	// 				Max: to.Ptr[int32](3),
	// 				Min: to.Ptr[int32](2),
	// 			},
	// 		},
	// 		DisableIPSecReplayProtection: to.Ptr(false),
	// 		EnableBgp: to.Ptr(false),
	// 		EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 		EnablePrivateIPAddress: to.Ptr(false),
	// 		GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeExpressRoute),
	// 		IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/ipConfigurations/default"),
	// 				Name: to.Ptr("gwipconfig1"),
	// 				Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 				Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 					PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodStatic),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					PublicIPAddress: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
	// 					},
	// 					Subnet: &armnetwork.SubResource{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
	// 					},
	// 				},
	// 		}},
	// 		NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule1"),
	// 				Name: to.Ptr("natRule1"),
	// 				Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
	// 				Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 					Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 					ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("50.0.0.0/24"),
	// 					}},
	// 					InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("10.10.0.0/24"),
	// 					}},
	// 					Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/ergw/natRules/natRule2"),
	// 				Name: to.Ptr("natRule2"),
	// 				Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
	// 				Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
	// 					Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
	// 					ExternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("30.0.0.0/24"),
	// 					}},
	// 					InternalMappings: []*armnetwork.VPNNatRuleMapping{
	// 						{
	// 							AddressSpace: to.Ptr("20.10.0.0/24"),
	// 					}},
	// 					Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 			Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUName("ErGwScale")),
	// 			Capacity: to.Ptr[int32](2),
	// 			Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTier("ErGwScale")),
	// 		},
	// 		VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
	// 		VPNType: to.Ptr(armnetwork.VPNTypePolicyBased),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayDelete.json
func ExampleVirtualNetworkGatewaysClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginDelete(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayUpdateTags.json
func ExampleVirtualNetworkGatewaysClient_BeginUpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginUpdateTags(ctx, "rg1", "vpngw", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("vpngw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		AllowRemoteVnetTraffic: to.Ptr(false),
	// 		AllowVirtualWanTraffic: to.Ptr(false),
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65515),
	// 			BgpPeeringAddress: to.Ptr("10.0.0.254"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.10")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.3.1.254")},
	// 							IPConfigurationID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("52.161.10.135")},
	// 						}},
	// 						PeerWeight: to.Ptr[int32](0),
	// 					},
	// 					CustomRoutes: &armnetwork.AddressSpace{
	// 						AddressPrefixes: []*string{
	// 							to.Ptr("101.168.0.6/32")},
	// 						},
	// 						DisableIPSecReplayProtection: to.Ptr(false),
	// 						EnableBgp: to.Ptr(false),
	// 						EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 						GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
	// 						IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default"),
	// 								Name: to.Ptr("default"),
	// 								Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 									PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									PublicIPAddress: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/testpub1"),
	// 									},
	// 									Subnet: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/GatewaySubnet"),
	// 									},
	// 								},
	// 						}},
	// 						NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 						},
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 						SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 							Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
	// 							Capacity: to.Ptr[int32](2),
	// 							Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
	// 						},
	// 						VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
	// 						VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayList.json
func ExampleVirtualNetworkGatewaysClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualNetworkGatewaysClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualNetworkGatewayListResult = armnetwork.VirtualNetworkGatewayListResult{
		// 	Value: []*armnetwork.VirtualNetworkGateway{
		// 		{
		// 			Name: to.Ptr("vpngw1"),
		// 			Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw1"),
		// 			Location: to.Ptr("loc1"),
		// 			Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 			Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
		// 				Active: to.Ptr(false),
		// 				AllowRemoteVnetTraffic: to.Ptr(false),
		// 				AllowVirtualWanTraffic: to.Ptr(false),
		// 				BgpSettings: &armnetwork.BgpSettings{
		// 					Asn: to.Ptr[int64](65515),
		// 					BgpPeeringAddress: to.Ptr("10.0.0.14"),
		// 					PeerWeight: to.Ptr[int32](0),
		// 				},
		// 				CustomRoutes: &armnetwork.AddressSpace{
		// 					AddressPrefixes: []*string{
		// 						to.Ptr("101.168.0.6/32")},
		// 					},
		// 					DisableIPSecReplayProtection: to.Ptr(false),
		// 					EnableBgp: to.Ptr(false),
		// 					EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 					EnablePrivateIPAddress: to.Ptr(false),
		// 					GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
		// 					IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw1/ipConfigurations/default"),
		// 							Name: to.Ptr("default"),
		// 							Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 							Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
		// 								PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								PublicIPAddress: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/vpngw1-ip"),
		// 								},
		// 								Subnet: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
		// 								},
		// 							},
		// 					}},
		// 					NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw1/natRules/natRule1"),
		// 							Name: to.Ptr("natRule1"),
		// 							Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
		// 							Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
		// 								Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 								ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 									{
		// 										AddressSpace: to.Ptr("50.0.0.0/24"),
		// 								}},
		// 								InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 									{
		// 										AddressSpace: to.Ptr("10.10.0.0/24"),
		// 								}},
		// 								Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							},
		// 						},
		// 						{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw1/natRules/natRule2"),
		// 							Name: to.Ptr("natRule2"),
		// 							Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
		// 							Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
		// 								Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 								ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 									{
		// 										AddressSpace: to.Ptr("30.0.0.0/24"),
		// 								}},
		// 								InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 									{
		// 										AddressSpace: to.Ptr("20.10.0.0/24"),
		// 								}},
		// 								Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							},
		// 					}},
		// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 					ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					SKU: &armnetwork.VirtualNetworkGatewaySKU{
		// 						Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
		// 						Capacity: to.Ptr[int32](2),
		// 						Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
		// 					},
		// 					VPNClientConfiguration: &armnetwork.VPNClientConfiguration{
		// 						VPNClientProtocols: []*armnetwork.VPNClientProtocol{
		// 						},
		// 						VPNClientRevokedCertificates: []*armnetwork.VPNClientRevokedCertificate{
		// 						},
		// 						VPNClientRootCertificates: []*armnetwork.VPNClientRootCertificate{
		// 						},
		// 					},
		// 					VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
		// 					VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("vpngw2"),
		// 				Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
		// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw2"),
		// 				Location: to.Ptr("loc2"),
		// 				Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 				Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
		// 					Active: to.Ptr(false),
		// 					AllowRemoteVnetTraffic: to.Ptr(false),
		// 					AllowVirtualWanTraffic: to.Ptr(false),
		// 					BgpSettings: &armnetwork.BgpSettings{
		// 						Asn: to.Ptr[int64](65515),
		// 						BgpPeeringAddress: to.Ptr("10.1.0.46"),
		// 						PeerWeight: to.Ptr[int32](0),
		// 					},
		// 					CustomRoutes: &armnetwork.AddressSpace{
		// 						AddressPrefixes: []*string{
		// 							to.Ptr("101.168.0.6/32")},
		// 						},
		// 						DisableIPSecReplayProtection: to.Ptr(false),
		// 						EnableBgp: to.Ptr(false),
		// 						EnableBgpRouteTranslationForNat: to.Ptr(false),
		// 						EnablePrivateIPAddress: to.Ptr(true),
		// 						GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
		// 						IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw2/ipConfigurations/default"),
		// 								Name: to.Ptr("default"),
		// 								Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
		// 								Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
		// 									PrivateIPAddress: to.Ptr("10.1.0.7"),
		// 									PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 									PublicIPAddress: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/vpngw2-ip"),
		// 									},
		// 									Subnet: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/GatewaySubnet"),
		// 									},
		// 								},
		// 						}},
		// 						NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw2/natRules/natRule1"),
		// 								Name: to.Ptr("natRule1"),
		// 								Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
		// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
		// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 										{
		// 											AddressSpace: to.Ptr("50.0.0.0/24"),
		// 									}},
		// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 										{
		// 											AddressSpace: to.Ptr("10.10.0.0/24"),
		// 									}},
		// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeEgressSnat),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 							},
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw2/natRules/natRule2"),
		// 								Name: to.Ptr("natRule2"),
		// 								Etag: to.Ptr("W/\"00ae2b69-88e7-4b3a-b66a-cfa2244e0801\""),
		// 								Properties: &armnetwork.VirtualNetworkGatewayNatRuleProperties{
		// 									Type: to.Ptr(armnetwork.VPNNatRuleTypeStatic),
		// 									ExternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 										{
		// 											AddressSpace: to.Ptr("30.0.0.0/24"),
		// 									}},
		// 									InternalMappings: []*armnetwork.VPNNatRuleMapping{
		// 										{
		// 											AddressSpace: to.Ptr("20.10.0.0/24"),
		// 									}},
		// 									Mode: to.Ptr(armnetwork.VPNNatRuleModeIngressSnat),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 						ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						SKU: &armnetwork.VirtualNetworkGatewaySKU{
		// 							Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
		// 							Capacity: to.Ptr[int32](2),
		// 							Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
		// 						},
		// 						VPNClientConfiguration: &armnetwork.VPNClientConfiguration{
		// 							RadiusServers: []*armnetwork.RadiusServer{
		// 								{
		// 									RadiusServerAddress: to.Ptr("10.2.0.0"),
		// 									RadiusServerScore: to.Ptr[int64](20),
		// 							}},
		// 							VPNClientProtocols: []*armnetwork.VPNClientProtocol{
		// 								to.Ptr(armnetwork.VPNClientProtocolOpenVPN)},
		// 								VPNClientRevokedCertificates: []*armnetwork.VPNClientRevokedCertificate{
		// 								},
		// 								VPNClientRootCertificates: []*armnetwork.VPNClientRootCertificate{
		// 								},
		// 							},
		// 							VPNGatewayGeneration: to.Ptr(armnetwork.VPNGatewayGenerationNone),
		// 							VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewaysListConnections.json
func ExampleVirtualNetworkGatewaysClient_NewListConnectionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualNetworkGatewaysClient().NewListConnectionsPager("testrg", "test-vpn-gateway-1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VirtualNetworkGatewayListConnectionsResult = armnetwork.VirtualNetworkGatewayListConnectionsResult{
		// 	Value: []*armnetwork.VirtualNetworkGatewayConnectionListEntity{
		// 		{
		// 			Name: to.Ptr("test-vpn-connection"),
		// 			Type: to.Ptr("Microsoft.Network/connections"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/connections/test-vpn-connection"),
		// 			Location: to.Ptr("eastus"),
		// 			Etag: to.Ptr("W/\\\"00000000-0000-0000-0000-000000000000\\\""),
		// 			Properties: &armnetwork.VirtualNetworkGatewayConnectionListEntityPropertiesFormat{
		// 				ConnectionType: to.Ptr(armnetwork.VirtualNetworkGatewayConnectionTypeVnet2Vnet),
		// 				EgressBytesTransferred: to.Ptr[int64](0),
		// 				EnableBgp: to.Ptr(true),
		// 				IngressBytesTransferred: to.Ptr[int64](0),
		// 				IPSecPolicies: []*armnetwork.IPSecPolicy{
		// 				},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				RoutingWeight: to.Ptr[int32](22),
		// 				TrafficSelectorPolicies: []*armnetwork.TrafficSelectorPolicy{
		// 				},
		// 				UsePolicyBasedTrafficSelectors: to.Ptr(false),
		// 				VirtualNetworkGateway1: &armnetwork.VirtualNetworkConnectionGatewayReference{
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkGateways/test-vpn-gateway-1"),
		// 				},
		// 				VirtualNetworkGateway2: &armnetwork.VirtualNetworkConnectionGatewayReference{
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/testrg-2/providers/Microsoft.Network/virtualNetworkGateways/test-vpn-gateway-2"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayReset.json
func ExampleVirtualNetworkGatewaysClient_BeginReset() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginReset(ctx, "rg1", "vpngw", &armnetwork.VirtualNetworkGatewaysClientBeginResetOptions{GatewayVip: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VirtualNetworkGateway = armnetwork.VirtualNetworkGateway{
	// 	Name: to.Ptr("vpngw"),
	// 	Type: to.Ptr("Microsoft.Network/virtualNetworkGateways"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
	// 	Location: to.Ptr("centralus"),
	// 	Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 	Properties: &armnetwork.VirtualNetworkGatewayPropertiesFormat{
	// 		Active: to.Ptr(false),
	// 		BgpSettings: &armnetwork.BgpSettings{
	// 			Asn: to.Ptr[int64](65514),
	// 			BgpPeeringAddress: to.Ptr("10.0.1.30"),
	// 			BgpPeeringAddresses: []*armnetwork.IPConfigurationBgpPeeringAddress{
	// 				{
	// 					CustomBgpIPAddresses: []*string{
	// 						to.Ptr("169.254.21.10")},
	// 						DefaultBgpIPAddresses: []*string{
	// 							to.Ptr("10.3.1.254")},
	// 							IPConfigurationID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 							TunnelIPAddresses: []*string{
	// 								to.Ptr("52.161.10.135")},
	// 						}},
	// 						PeerWeight: to.Ptr[int32](0),
	// 					},
	// 					CustomRoutes: &armnetwork.AddressSpace{
	// 						AddressPrefixes: []*string{
	// 							to.Ptr("101.168.0.6/32")},
	// 						},
	// 						DisableIPSecReplayProtection: to.Ptr(false),
	// 						EnableBgp: to.Ptr(false),
	// 						EnableBgpRouteTranslationForNat: to.Ptr(false),
	// 						GatewayType: to.Ptr(armnetwork.VirtualNetworkGatewayTypeVPN),
	// 						IPConfigurations: []*armnetwork.VirtualNetworkGatewayIPConfiguration{
	// 							{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
	// 								Name: to.Ptr("gwipconfig1"),
	// 								Etag: to.Ptr("W/\"00000000-0000-0000-0000-000000000000\""),
	// 								Properties: &armnetwork.VirtualNetworkGatewayIPConfigurationPropertiesFormat{
	// 									PrivateIPAllocationMethod: to.Ptr(armnetwork.IPAllocationMethodDynamic),
	// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 									PublicIPAddress: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
	// 									},
	// 									Subnet: &armnetwork.SubResource{
	// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
	// 									},
	// 								},
	// 						}},
	// 						NatRules: []*armnetwork.VirtualNetworkGatewayNatRule{
	// 						},
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 						SKU: &armnetwork.VirtualNetworkGatewaySKU{
	// 							Name: to.Ptr(armnetwork.VirtualNetworkGatewaySKUNameVPNGw1),
	// 							Capacity: to.Ptr[int32](0),
	// 							Tier: to.Ptr(armnetwork.VirtualNetworkGatewaySKUTierVPNGw1),
	// 						},
	// 						VPNType: to.Ptr(armnetwork.VPNTypeRouteBased),
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayResetVpnClientSharedKey.json
func ExampleVirtualNetworkGatewaysClient_BeginResetVPNClientSharedKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginResetVPNClientSharedKey(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGenerateVpnClientPackage.json
func ExampleVirtualNetworkGatewaysClient_BeginGeneratevpnclientpackage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGeneratevpnclientpackage(ctx, "rg1", "vpngw", armnetwork.VPNClientParameters{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = ""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGenerateVpnProfile.json
func ExampleVirtualNetworkGatewaysClient_BeginGenerateVPNProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGenerateVPNProfile(ctx, "rg1", "vpngw", armnetwork.VPNClientParameters{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = ""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGetVpnProfilePackageUrl.json
func ExampleVirtualNetworkGatewaysClient_BeginGetVPNProfilePackageURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetVPNProfilePackageURL(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = ""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGetBGPPeerStatus.json
func ExampleVirtualNetworkGatewaysClient_BeginGetBgpPeerStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetBgpPeerStatus(ctx, "rg1", "vpngw", &armnetwork.VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions{Peer: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BgpPeerStatusListResult = armnetwork.BgpPeerStatusListResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewaySupportedVpnDevice.json
func ExampleVirtualNetworkGatewaysClient_SupportedVPNDevices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualNetworkGatewaysClient().SupportedVPNDevices(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "<?xml version=\"1.0\" encoding=\"utf-8\"?><RpVpnDeviceList version=\"1.0\"><Vendor name=\"Cisco\"><DeviceFamily name=\"ISR\"><FirmwareVersion name=\"IOS 15.1 (Preview)\" /></DeviceFamily><DeviceFamily name=\"ASA (Adaptive Security Appliance)\"><FirmwareVersion name=\"ASA_9.8.x_ActivePassive_NoBGP_NoCustomPolicies\"/><FirmwareVersion name=\"ASA_9.8(x)_CustomPolicies\" /></DeviceFamily></Vendor><Vendor name=\"Juniper\"><DeviceFamily name=\"Juniper_SRX_GA\"><FirmwareVersion name=\"Juniper_SRX_12.x_GA\" /></DeviceFamily><DeviceFamily name=\"Juniper_SSG_GA\"><FirmwareVersion name=\"Juniper_SSG_ScreenOS-6.2.x_GA\"/></DeviceFamily><DeviceFamily name=\"Juniper_JSeries_GA\"><FirmwareVersion name=\"Juniper_JSeries_JunOS12.x._GA\" /></DeviceFamily></Vendor><Vendor name=\"Ubiquiti\"><DeviceFamily name=\"EdgeRouter\"><FirmwareVersion name=\"Ubiquiti_EdgeOS_1.10.x-RouteBased_VTI\" /><FirmwareVersionname=\"Ubiquiti_EdgeOS_1.10.x-RouteBased_BGP\" /></DeviceFamily></Vendor></RpVpnDeviceList>"
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayLearnedRoutes.json
func ExampleVirtualNetworkGatewaysClient_BeginGetLearnedRoutes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetLearnedRoutes(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GatewayRouteListResult = armnetwork.GatewayRouteListResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGetAdvertisedRoutes.json
func ExampleVirtualNetworkGatewaysClient_BeginGetAdvertisedRoutes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetAdvertisedRoutes(ctx, "rg1", "vpngw", "test", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GatewayRouteListResult = armnetwork.GatewayRouteListResult{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewaySetVpnClientIpsecParameters.json
func ExampleVirtualNetworkGatewaysClient_BeginSetVpnclientIPSecParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginSetVpnclientIPSecParameters(ctx, "rg1", "vpngw", armnetwork.VPNClientIPsecParameters{
		DhGroup:             to.Ptr(armnetwork.DhGroupDHGroup2),
		IkeEncryption:       to.Ptr(armnetwork.IkeEncryptionAES256),
		IkeIntegrity:        to.Ptr(armnetwork.IkeIntegritySHA384),
		IPSecEncryption:     to.Ptr(armnetwork.IPSecEncryptionAES256),
		IPSecIntegrity:      to.Ptr(armnetwork.IPSecIntegritySHA256),
		PfsGroup:            to.Ptr(armnetwork.PfsGroupPFS2),
		SaDataSizeKilobytes: to.Ptr[int32](429497),
		SaLifeTimeSeconds:   to.Ptr[int32](86473),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNClientIPsecParameters = armnetwork.VPNClientIPsecParameters{
	// 	DhGroup: to.Ptr(armnetwork.DhGroupDHGroup2),
	// 	IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
	// 	IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
	// 	IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
	// 	IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
	// 	PfsGroup: to.Ptr(armnetwork.PfsGroupPFS2),
	// 	SaDataSizeKilobytes: to.Ptr[int32](429497),
	// 	SaLifeTimeSeconds: to.Ptr[int32](86473),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGetVpnClientIpsecParameters.json
func ExampleVirtualNetworkGatewaysClient_BeginGetVpnclientIPSecParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetVpnclientIPSecParameters(ctx, "rg1", "vpngw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNClientIPsecParameters = armnetwork.VPNClientIPsecParameters{
	// 	DhGroup: to.Ptr(armnetwork.DhGroupDHGroup2),
	// 	IkeEncryption: to.Ptr(armnetwork.IkeEncryptionAES256),
	// 	IkeIntegrity: to.Ptr(armnetwork.IkeIntegritySHA384),
	// 	IPSecEncryption: to.Ptr(armnetwork.IPSecEncryptionAES256),
	// 	IPSecIntegrity: to.Ptr(armnetwork.IPSecIntegritySHA256),
	// 	PfsGroup: to.Ptr(armnetwork.PfsGroupPFS2),
	// 	SaDataSizeKilobytes: to.Ptr[int32](429497),
	// 	SaLifeTimeSeconds: to.Ptr[int32](86473),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayVpnDeviceConfigurationScript.json
func ExampleVirtualNetworkGatewaysClient_VPNDeviceConfigurationScript() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualNetworkGatewaysClient().VPNDeviceConfigurationScript(ctx, "rg1", "vpngw", armnetwork.VPNDeviceScriptParameters{
		DeviceFamily:    to.Ptr("ISR"),
		FirmwareVersion: to.Ptr("IOS 15.1 (Preview)"),
		Vendor:          to.Ptr("Cisco"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "! Microsoft Corporation\r\n! ---------------------------------------------------------------------------------------------------------------------\r\n! Sample VPN tunnel configuration template for IOS-based devices\r\n!\r\n! This configuration template applies to Cisco VPN devices running IOS 15.1 or beyond (ISR or ASR)\r\n!\r\n\r\n\r\n		\r\n\r\n! ---------------------------------------------------------------------------------------------------------------------\r\n! ACL rules\r\n!\r\n! Some VPN devices require explicit ACL rules to allow cross-premises traffic:\r\n!\r\n! 1. Allow traffic between on premises address ranges and VNet address ranges\r\n! 2. Allow IKE traffic (UDP:500) between on premises VPN devices and Azure VPN gateway\r\n! 3. Allow IPsec traffic (Proto:ESP) between on premises VPN devices and Azure VPN gateway\r\n!\r\n		\r\naccess-list 101 permit ip 10.1.0.0 0.0.255.255 10.0.0.0 0.0.255.255\r\n\r\n! ---------------------------------------------------------------------------------------------------------------------\r\n! Internet Key Exchange (IKE) configuration\r\n!\r\n! This section specifies the authentication, encryption, hashing, and Diffie-Hellman group parameters for IKE\r\n! main mode or phase 1\r\n!\r\n\r\ncrypto ikev2 proposal SwaggerS2S-proposal\r\n  encryption DES3\r\n  integrity  SHA384\r\n  group      DHGroup24\r\n  lifetime   3600\r\n exit\r\n\r\ncrypto ikev2 policy SwaggerS2S-policy\r\n  proposal SwaggerS2S-proposal\r\n  exit\r\n\r\ncrypto ikev2 keyring SwaggerBranch-keyring\r\n		\r\n		peer 52.173.199.254\r\n		address        52.173.199.254\r\n		pre-shared-key lALEHuppeopJmA94exRNiRr2QzuZ6lOsvzu5IlJUEA6LthbTc8g5MTT86MCsGNMzGkTAaLuLnEJoD1Cn4cIlr94qKZm9drsgllzWvsPNezS71stAkaW1Bb7h6GBnDlDP\r\n  exit\r\n\r\ncrypto ikev2 profile  SwaggerS2S-profile\r\n  match address  local 10.3.0.0\r\n	match identity remote address 52.173.199.254 255.255.255.255\r\n		\r\n  authentication remote pre-share\r\n  authentication local  pre-share\r\n  keyring        SwaggerBranch-keyring\r\n  exit\r\n\r\n! ---------------------------------------------------------------------------------------------------------------------\r\n! IPsec configuration\r\n!\r\n! This section specifies encryption, authentication, tunnel mode properties for the Phase 2 negotiation\r\n!\r\ncrypto ipsec transform-set SwaggerS2S-TransformSet DES3 DES3\r\n mode  tunnel\r\n exit\r\n\r\n! ---------------------------------------------------------------------------------------------------------------------\r\n! Crypto map configuration\r\n!\r\n! This section defines a crypto profile that binds the cross-premises network traffic to the IPsec and IKE\r\n! policy profiles for this connection. Then defines the VTI (virtual tunnel interface) with the crypto\r\n! profile. A random interface number (tunnel 1) was used with a random link local address (169.254.0.1/28)\r\n! for the tunnel interface. If either selection is already used in the VPN device, please select another\r\n! interface number or address.  The only requirement is that they must not overlap with another interface\r\n! on the same VPN device.\r\n!\r\ncrypto ipsec profile SwaggerS2S-IPsecProfile\r\n  set transform-set  SwaggerS2S-TransformSet\r\n  set ikev2-profile  SwaggerS2S-profile\r\n  set pfs            None\r\n  set security-association lifetime 3600\r\n exit\r\n\r\n\r\nint tunnel 52.173.199.254\r\n  ip address 169.254.0.1 255.255.255.252\r\n  ip tcp adjust-mss 1350\r\n  tunnel source 10.3.0.0\r\n  tunnel mode ipsec ipv4\r\n  tunnel destination 52.173.199.254\r\n  tunnel protection ipsec profile SwaggerS2S-IPsecProfile\r\n  exit\r\n\r\n	ip route 10.0.0.0 255.255.0.0 tunnel 52.173.199.254 "
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayStartPacketCaptureFilterData.json
func ExampleVirtualNetworkGatewaysClient_BeginStartPacketCapture_startPacketCaptureOnVirtualNetworkGatewayWithFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginStartPacketCapture(ctx, "rg1", "vpngw", &armnetwork.VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions{Parameters: &armnetwork.VPNPacketCaptureStartParameters{
		FilterData: to.Ptr("{'TracingFlags': 11,'MaxPacketBufferSize': 120,'MaxFileSize': 200,'Filters': [{'SourceSubnets': ['20.1.1.0/24'],'DestinationSubnets': ['10.1.1.0/24'],'SourcePort': [500],'DestinationPort': [4500],'Protocol': 6,'TcpFlags': 16,'CaptureSingleDirectionTrafficOnly': true}]}"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayStartPacketCapture.json
func ExampleVirtualNetworkGatewaysClient_BeginStartPacketCapture_startPacketCaptureOnVirtualNetworkGatewayWithoutFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginStartPacketCapture(ctx, "rg1", "vpngw", &armnetwork.VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions{Parameters: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayStopPacketCapture.json
func ExampleVirtualNetworkGatewaysClient_BeginStopPacketCapture() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginStopPacketCapture(ctx, "rg1", "vpngw", armnetwork.VPNPacketCaptureStopParameters{
		SasURL: to.Ptr("https://teststorage.blob.core.windows.net/?sv=2018-03-28&ss=bfqt&srt=sco&sp=rwdlacup&se=2019-09-13T07:44:05Z&st=2019-09-06T23:44:05Z&spr=https&sig=V1h9D1riltvZMI69d6ihENnFo%2FrCvTqGgjO2lf%2FVBhE%3D"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Value = "\"{\"Status\":\"Successful\",\"Data\":null}\""
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewayGetVpnclientConnectionHealth.json
func ExampleVirtualNetworkGatewaysClient_BeginGetVpnclientConnectionHealth() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginGetVpnclientConnectionHealth(ctx, "p2s-vnet-test", "vpnp2sgw", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VPNClientConnectionHealthDetailListResult = armnetwork.VPNClientConnectionHealthDetailListResult{
	// 	Value: []*armnetwork.VPNClientConnectionHealthDetail{
	// 		{
	// 			EgressBytesTransferred: to.Ptr[int64](33420),
	// 			EgressPacketsTransferred: to.Ptr[int64](557),
	// 			IngressBytesTransferred: to.Ptr[int64](33420),
	// 			IngressPacketsTransferred: to.Ptr[int64](557),
	// 			MaxBandwidth: to.Ptr[int64](240000000),
	// 			MaxPacketsPerSecond: to.Ptr[int64](4),
	// 			PrivateIPAddress: to.Ptr("192.168.210.2"),
	// 			PublicIPAddress: to.Ptr("167.220.2.232:45522"),
	// 			VPNConnectionDuration: to.Ptr[int64](900),
	// 			VPNConnectionID: to.Ptr("IKEv2_1e1cfe59-5c7c-4315-a876-b11fbfdfeed4"),
	// 			VPNConnectionTime: to.Ptr("2019-05-02T22:26:22"),
	// 			VPNUserName: to.Ptr("gwp2schildcert"),
	// 		},
	// 		{
	// 			EgressBytesTransferred: to.Ptr[int64](23420),
	// 			EgressPacketsTransferred: to.Ptr[int64](357),
	// 			IngressBytesTransferred: to.Ptr[int64](23420),
	// 			IngressPacketsTransferred: to.Ptr[int64](357),
	// 			MaxBandwidth: to.Ptr[int64](220000000),
	// 			MaxPacketsPerSecond: to.Ptr[int64](4),
	// 			PrivateIPAddress: to.Ptr("192.168.210.1"),
	// 			PublicIPAddress: to.Ptr("167.220.2.232:45213"),
	// 			VPNConnectionDuration: to.Ptr[int64](800),
	// 			VPNConnectionID: to.Ptr("IKEv2_571cfe59-2c7d-1415-e813-c51fbfdfea16"),
	// 			VPNConnectionTime: to.Ptr("2019-05-01T21:06:12"),
	// 			VPNUserName: to.Ptr("gwp2schildcert"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/VirtualNetworkGatewaysDisconnectP2sVpnConnections.json
func ExampleVirtualNetworkGatewaysClient_BeginDisconnectVirtualNetworkGatewayVPNConnections() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualNetworkGatewaysClient().BeginDisconnectVirtualNetworkGatewayVPNConnections(ctx, "vpn-gateway-test", "vpngateway", armnetwork.P2SVPNConnectionRequest{
		VPNConnectionIDs: []*string{
			to.Ptr("vpnconnId1"),
			to.Ptr("vpnconnId2")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
