//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LongTermRetentionManagedInstanceBackupsServer is a fake server for instances of the armsql.LongTermRetentionManagedInstanceBackupsClient type.
type LongTermRetentionManagedInstanceBackupsServer struct {
	// BeginDelete is the fake for method LongTermRetentionManagedInstanceBackupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDelete func(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteByResourceGroup is the fake for method LongTermRetentionManagedInstanceBackupsClient.BeginDeleteByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientBeginDeleteByResourceGroupOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteByResourceGroupResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LongTermRetentionManagedInstanceBackupsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientGetOptions) (resp azfake.Responder[armsql.LongTermRetentionManagedInstanceBackupsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByResourceGroup is the fake for method LongTermRetentionManagedInstanceBackupsClient.GetByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupOptions) (resp azfake.Responder[armsql.LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(locationName string, managedInstanceName string, databaseName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse])

	// NewListByInstancePager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInstancePager func(locationName string, managedInstanceName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse])

	// NewListByLocationPager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(locationName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationResponse])

	// NewListByResourceGroupDatabasePager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupDatabasePager func(resourceGroupName string, locationName string, managedInstanceName string, databaseName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse])

	// NewListByResourceGroupInstancePager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupInstancePager func(resourceGroupName string, locationName string, managedInstanceName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse])

	// NewListByResourceGroupLocationPager is the fake for method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupLocationPager func(resourceGroupName string, locationName string, options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse])
}

// NewLongTermRetentionManagedInstanceBackupsServerTransport creates a new instance of LongTermRetentionManagedInstanceBackupsServerTransport with the provided implementation.
// The returned LongTermRetentionManagedInstanceBackupsServerTransport instance is connected to an instance of armsql.LongTermRetentionManagedInstanceBackupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLongTermRetentionManagedInstanceBackupsServerTransport(srv *LongTermRetentionManagedInstanceBackupsServer) *LongTermRetentionManagedInstanceBackupsServerTransport {
	return &LongTermRetentionManagedInstanceBackupsServerTransport{
		srv:                                 srv,
		beginDelete:                         newTracker[azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteResponse]](),
		beginDeleteByResourceGroup:          newTracker[azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteByResourceGroupResponse]](),
		newListByDatabasePager:              newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse]](),
		newListByInstancePager:              newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse]](),
		newListByLocationPager:              newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationResponse]](),
		newListByResourceGroupDatabasePager: newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse]](),
		newListByResourceGroupInstancePager: newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse]](),
		newListByResourceGroupLocationPager: newTracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse]](),
	}
}

// LongTermRetentionManagedInstanceBackupsServerTransport connects instances of armsql.LongTermRetentionManagedInstanceBackupsClient to instances of LongTermRetentionManagedInstanceBackupsServer.
// Don't use this type directly, use NewLongTermRetentionManagedInstanceBackupsServerTransport instead.
type LongTermRetentionManagedInstanceBackupsServerTransport struct {
	srv                                 *LongTermRetentionManagedInstanceBackupsServer
	beginDelete                         *tracker[azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteResponse]]
	beginDeleteByResourceGroup          *tracker[azfake.PollerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientDeleteByResourceGroupResponse]]
	newListByDatabasePager              *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse]]
	newListByInstancePager              *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse]]
	newListByLocationPager              *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationResponse]]
	newListByResourceGroupDatabasePager *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse]]
	newListByResourceGroupInstancePager *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse]]
	newListByResourceGroupLocationPager *tracker[azfake.PagerResponder[armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse]]
}

// Do implements the policy.Transporter interface for LongTermRetentionManagedInstanceBackupsServerTransport.
func (l *LongTermRetentionManagedInstanceBackupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LongTermRetentionManagedInstanceBackupsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LongTermRetentionManagedInstanceBackupsClient.BeginDeleteByResourceGroup":
		resp, err = l.dispatchBeginDeleteByResourceGroup(req)
	case "LongTermRetentionManagedInstanceBackupsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LongTermRetentionManagedInstanceBackupsClient.GetByResourceGroup":
		resp, err = l.dispatchGetByResourceGroup(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByDatabasePager":
		resp, err = l.dispatchNewListByDatabasePager(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByInstancePager":
		resp, err = l.dispatchNewListByInstancePager(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByLocationPager":
		resp, err = l.dispatchNewListByLocationPager(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupDatabasePager":
		resp, err = l.dispatchNewListByResourceGroupDatabasePager(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupInstancePager":
		resp, err = l.dispatchNewListByResourceGroupInstancePager(req)
	case "LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupLocationPager":
		resp, err = l.dispatchNewListByResourceGroupLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), locationNameParam, managedInstanceNameParam, databaseNameParam, backupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchBeginDeleteByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDeleteByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteByResourceGroup not implemented")}
	}
	beginDeleteByResourceGroup := l.beginDeleteByResourceGroup.get(req)
	if beginDeleteByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDeleteByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, managedInstanceNameParam, databaseNameParam, backupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteByResourceGroup = &respr
		l.beginDeleteByResourceGroup.add(req, beginDeleteByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginDeleteByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginDeleteByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteByResourceGroup) {
		l.beginDeleteByResourceGroup.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), locationNameParam, managedInstanceNameParam, databaseNameParam, backupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstanceLongTermRetentionBackup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchGetByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.GetByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, managedInstanceNameParam, databaseNameParam, backupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstanceLongTermRetentionBackup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := l.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByDatabasePager(locationNameParam, managedInstanceNameParam, databaseNameParam, options)
		newListByDatabasePager = &resp
		l.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		l.newListByDatabasePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByInstancePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInstancePager not implemented")}
	}
	newListByInstancePager := l.newListByInstancePager.get(req)
	if newListByInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByInstancePager(locationNameParam, managedInstanceNameParam, options)
		newListByInstancePager = &resp
		l.newListByInstancePager.add(req, newListByInstancePager)
		server.PagerResponderInjectNextLinks(newListByInstancePager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInstancePager) {
		l.newListByInstancePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := l.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByLocationPager(locationNameParam, options)
		newListByLocationPager = &resp
		l.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		l.newListByLocationPager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByResourceGroupDatabasePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupDatabasePager not implemented")}
	}
	newListByResourceGroupDatabasePager := l.newListByResourceGroupDatabasePager.get(req)
	if newListByResourceGroupDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupDatabasePager(resourceGroupNameParam, locationNameParam, managedInstanceNameParam, databaseNameParam, options)
		newListByResourceGroupDatabasePager = &resp
		l.newListByResourceGroupDatabasePager.add(req, newListByResourceGroupDatabasePager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupDatabasePager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupDatabasePager) {
		l.newListByResourceGroupDatabasePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByResourceGroupInstancePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupInstancePager not implemented")}
	}
	newListByResourceGroupInstancePager := l.newListByResourceGroupInstancePager.get(req)
	if newListByResourceGroupInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupInstancePager(resourceGroupNameParam, locationNameParam, managedInstanceNameParam, options)
		newListByResourceGroupInstancePager = &resp
		l.newListByResourceGroupInstancePager.add(req, newListByResourceGroupInstancePager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupInstancePager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupInstancePager) {
		l.newListByResourceGroupInstancePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionManagedInstanceBackupsServerTransport) dispatchNewListByResourceGroupLocationPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupLocationPager not implemented")}
	}
	newListByResourceGroupLocationPager := l.newListByResourceGroupLocationPager.get(req)
	if newListByResourceGroupLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionManagedInstanceBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupLocationPager(resourceGroupNameParam, locationNameParam, options)
		newListByResourceGroupLocationPager = &resp
		l.newListByResourceGroupLocationPager.add(req, newListByResourceGroupLocationPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupLocationPager, req, func(page *armsql.LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupLocationPager) {
		l.newListByResourceGroupLocationPager.remove(req)
	}
	return resp, nil
}
