/*
 *  $Id: math.c 28916 2025-11-26 17:39:55Z yeti-dn $
 *  Copyright (C) 2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "tests/testlibgwy.h"

void
test_math_powi_zero(void)
{
    g_assert_cmpfloat(gwy_powi(1.0, 0), ==, 1.0);
    g_assert_cmpfloat(gwy_powi(0.25, 0), ==, 1.0);
    g_assert_cmpfloat(gwy_powi(-G_MAXDOUBLE, 0), ==, 1.0);
    // This is what pow() specifies so we should require it from powi.
    g_assert_cmpfloat(gwy_powi(0.0, 0), ==, 1.0);
}

void
test_math_powi_one(void)
{
    g_assert_cmpfloat(gwy_powi(1.0, 1), ==, 1.0);
    g_assert_cmpfloat(gwy_powi(1.0, -1), ==, 1.0);
    g_assert_cmpfloat(gwy_powi(1.0, 1753), ==, 1.0);
    g_assert_cmpfloat(gwy_powi(1.0, -486), ==, 1.0);
}

void
test_math_powi_basic(void)
{
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, 2), 4.0, 4*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, -2), 0.25, DBL_EPSILON/4);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, 2), 4.0, 4*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, -2), 0.25, DBL_EPSILON/4);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, 3), 8.0, 8*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, -3), 0.125, DBL_EPSILON/8);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, 3), -8.0, 8*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, -3), -0.125, DBL_EPSILON/8);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, 4), 16.0, 16*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, -4), 0.0625, DBL_EPSILON/16);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, 4), 16.0, 16*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, -4), 0.0625, DBL_EPSILON/16);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, 5), 32.0, 32*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(2.0, -5), 0.03125, DBL_EPSILON/32);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, 5), -32.0, 32*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_powi(-2.0, -5), -0.03125, DBL_EPSILON/32);
}

void
test_math_deg2rad(void)
{
    g_assert_cmpfloat(gwy_deg2rad(0.0), ==, 0.0);
    g_assert_cmpfloat_with_epsilon(gwy_deg2rad(360.0), 2*G_PI, 6*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_deg2rad(-45.0), -G_PI/4.0, DBL_EPSILON);
}

void
test_math_rad2deg(void)
{
    g_assert_cmpfloat(gwy_rad2deg(0.0), ==, 0.0);
    g_assert_cmpfloat_with_epsilon(gwy_rad2deg(2.0*G_PI), 360.0, 360*DBL_EPSILON);
    g_assert_cmpfloat_with_epsilon(gwy_rad2deg(-G_PI/3.0), -60.0, 60*DBL_EPSILON);
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
