# Contributing to The ioquake3 Project

The following is a set of guidelines for contributing to ioquake3 which is hosted in the [The ioquake Group](https://github.com/ioquake) on Github. The intent of this project is to provide a baseline engine which may be used for further development and to play Quake 3: Arena, Team Arena, and mods. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Table Of Contents

[I don't want to read this whole thing, I just have a question!!!](#i-dont-want-to-read-this-whole-thing-i-just-have-a-question)

[How Can I Contribute?](#how-can-i-contribute)
  * [Reporting Bugs](#reporting-bugs)
  * [Suggesting Enhancements](#suggesting-enhancements)
  * [Your First Code Contribution](#your-first-code-contribution)
  * [Pull Requests](#pull-requests)
[Additional Notes](#additional-notes)
  * [Issue and Pull Request Labels](#issue-and-pull-request-labels)

## I don't want to read this whole thing I just have a question!!!

> **Note:** Please don't file an issue to ask a question. You'll get faster results by using the resources below.

We have an official message board where the community provides helpful advice if you have questions.

* [Discourse, the official ioquake message board](https://discourse.ioquake.org)

If you'd prefer to chat live with other users, sysadmins, and developers, we have IRC and Discord, with a bridge between the two:
* IRC: We're on Libera Chat (```irc.libera.chat```) in ```#ioquake3```
* Or you can join our Discord [via this link](https://discord.gg/fPaGNuy)
With either of these services it might take a while before someone responds to your question, if you can't wait, [use the forums](https://discourse.ioquake.org)

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for ioquake3. Following these guidelines helps maintainers and the community understand your report :pencil:, reproduce the behavior :computer: :computer:, and find related reports :mag_right:.

Before creating bug reports, please check [this list](#before-submitting-a-bug-report) as you might find out that you don't need to create one. When you are creating a bug report, please [include as many details as possible](#how-do-i-submit-a-good-bug-report). Fill out [the required template](ISSUE_TEMPLATE.md), the information it asks for helps us resolve issues faster.

> **Note:** If you find a **Closed** issue that seems like it is the same thing that you're experiencing, open a new issue and include a link to the original issue in the body of your new one.

#### Before Submitting A Bug Report

* **Check the latest version** The version in our installers is from 2009! Check if you can reproduce the problem [in the latest test build of ioquake3](http://ioquake3.org/get-it/test-builds/).
* **Search the [forum](https://discourse.ioquake.org)** for your questions and problems.
* **Perform a [cursory search](https://github.com/search?q=+is%3Aissue+user%3Aioquake)** to see if the problem has already been reported. If it has **and the issue is still open**, add a comment to the existing issue instead of opening a new one.

#### How Do I Submit A (Good) Bug Report?

Bugs are tracked as [GitHub issues](https://guides.github.com/features/issues/). Create an issue and provide the following information by filling in [the template](ISSUE_TEMPLATE.md).

Explain the problem and include additional details to help maintainers reproduce the problem:

* **Use a clear and descriptive title** for the issue to identify the problem.
* **Describe the exact steps which reproduce the problem** in as many details as possible. For example, start by explaining how you started ioquake3, e.g. which command exactly you used in the terminal, or how you started ioquake3 with a shortcut. When listing steps, **don't just say what you did, but explain how you did it**. For example, if you started a new map, explain if you used the menu, or a keyboard macro, or a / command in the ioquake3 console, and if so which one?
* **Provide specific examples to demonstrate the steps**. Include links to files or GitHub projects, or copy/pasteable snippets, which you use in those examples. If you're providing snippets in the issue, use [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
* **Describe the behavior you observed after following the steps** and point out what exactly is the problem with that behavior.
* **Explain which behavior you expected to see instead and why.**
* **Include screenshots** which show you following the described steps and clearly demonstrate the problem.
* **If you're reporting that ioquake3 crashed**, include a crash report with a stack trace from the operating system. Include the crash report in the issue in a [code block](https://help.github.com/articles/markdown-basics/#multiple-lines), a [file attachment](https://help.github.com/articles/file-attachments-on-issues-and-pull-requests/), or put it in a [gist](https://gist.github.com/) and provide link to that gist.
* **If the problem wasn't triggered by a specific action**, describe what you were doing before the problem happened and share more information using the guidelines below.

Provide more context by answering these questions:

* **Did the problem start happening recently** (e.g. after updating to a new version of ioquake3) or was this always a problem?
* If the problem started happening recently, **can you reproduce the problem in an older version of ioquake3?** What's the most recent version in which the problem doesn't happen?
* **Can you reliably reproduce the issue?** If not, provide details about how often the problem happens and under which conditions it normally happens.
* If the problem is related to working with third party pk3s and mods (e.g. opening and editing files), **does the problem happen with baseq3?** We need to be able to reproduce the issue with baseq3, usually.

Include details about your configuration and environment:

* **Which version of ioquake3 are you using?**
* **What's the name and version of the OS you're using?**
* **What graphics card or chipset is in your computer?**

### Helping others
People have questions, they ask them on our [forums](https://discourse.ioquake.org/), Discord, and on other services and websites. Answer them if you can, and suggest they get added to the [Players Guide](https://ioquake3.org/help/players-guide/) or [Sys Admin Guide](https://ioquake3.org/help/sys-admin-guide/) if the same questions keep coming up. If the answers are already in the one of our guides, copy and paste the answer and then link the people asking questions to those pages if they have more questions.

### Tip ioquake3 developers
Money buys servers, hosting, and time. [Support ioquake3 developers directly through the links on this page](https://ioquake3.org/help/get-involved/).

### Social Media
Follow ioquake3 [on Mastodon](https://mastodon.social/@ioquake3) and [on Blue Sky](https://bsky.app/profile/ioquake3.org). Let other Quake 3 players know about ioquake3, some people are still playing with id's client!

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for ioquake3, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion :pencil: and find related suggestions :mag_right:.

Before creating enhancement suggestions, please check [this list](#before-submitting-an-enhancement-suggestion) as you might find out that you don't need to create one. When you are creating an enhancement suggestion, please [include as many details as possible](#how-do-i-submit-a-good-enhancement-suggestion). Fill in [the template](ISSUE_TEMPLATE.md), including the steps that you imagine you would take if the feature you're requesting existed.

#### Before Submitting An Enhancement Suggestion

* **Check the latest test build** you might discover that the enhancement is already available.
* **Perform a [cursory search](https://github.com/search?q=+is%3Aissue+user%3Aioquake)** to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.

#### How Do I Submit A (Good) Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://guides.github.com/features/issues/). Create an issue on the ioquake3 repository and provide the following information:

* **Use a clear and descriptive title** for the issue to identify the suggestion.
* **Provide a step-by-step description of the suggested enhancement** in as many details as possible.
* **Provide specific examples to demonstrate the steps**. Include copy/pasteable snippets which you use in those examples, as [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
* **Describe the current behavior** and **explain which behavior you expected to see instead** and why.
* **Include screenshots** which help you demonstrate the steps or point out the part of ioquake3 which the suggestion is related to.
* **Explain why this enhancement would be useful** to most ioquake3 users.
* **Specify which version of ioquake3 you're using.** 
* **Specify the name and version of the OS you're using.**

### Your First Code Contribution

Unsure where to begin contributing to ioquake3?

Check out our issues and pull requests, you can review and make new suggestions.

We also have a label called [new contributor](https://github.com/ioquake/ioq3/issues?q=state%3Aopen%20label%3A%22new%20contributor%22) that might be a good starting point.

#### Local development

ioquake3 can be developed locally. For instructions on how to do this, read the README.md.

### Pull Requests

* Fill in [the required template](PULL_REQUEST_TEMPLATE.md)
* Do not include issue numbers in the PR title.


### Building Official Installers

This is a reminder for how official installers should be built:

  * Please include the id patch pk3s in your installer, which are available
    from http://ioquake3.org/patch-data/ subject to agreement to the id
    EULA. Your installer shall also ask the user to agree to this EULA (which
    is in the /web/include directory for your convenience) and subsequently
    refuse to continue the installation of the patch pk3s and pak0.pk3 if they
    do not.

  * Please don't require pak0.pk3, since not everyone using the engine
    plans on playing Quake 3 Arena on it. It's fine to (optionally) assist the
    user in copying the file or tell them how.

  * It is fine to just install the binaries without requiring id EULA agreement,
    providing pak0.pk3 and the patch pk3s are not referred to or included in the
    installer.

  * Please include at least a libSDL2 so/dylib/dll on every platform.

  * Please include an OpenAL so/dylib/dll, since every platform should be using
    it by now.

  * Please be prepared to alter your installer on the whim of the maintainers.

  * Your installer will be mirrored to an "official" directory, thus making it
    a done deal.

