/****************************************************************************
** Copyright (c) 2021, Fougue Ltd. <http://www.fougue.pro>
** All rights reserved.
** See license at https://github.com/fougue/mayo/blob/master/LICENSE.txt
****************************************************************************/

#pragma once

#include <utility>

namespace Mayo::IO {

struct RGB_Color {
    int r;
    int g;
    int b;
};

// Source: https://gohtx.com/acadcolors.php
const std::pair<int, RGB_Color> aciTable[] = {
    { 0, RGB_Color{ 0, 0, 0 } },
    { 1, RGB_Color{ 255, 0, 0 } },
    { 2, RGB_Color{ 255, 255, 0 } },
    { 3, RGB_Color{ 0, 255, 0 } },
    { 4, RGB_Color{ 0, 255, 255 } },
    { 5, RGB_Color{ 0, 0, 255 } },
    { 6, RGB_Color{ 255, 0, 255 } },
    { 7, RGB_Color{ 255, 255, 255 } },
    { 8, RGB_Color{ 65, 65, 65 } },
    { 9, RGB_Color{ 128, 128, 128 } },
    { 10, RGB_Color{ 255, 0, 0 } },
    { 11, RGB_Color{ 255, 170, 170 } },
    { 12, RGB_Color{ 189, 0, 0 } },
    { 13, RGB_Color{ 189, 126, 126 } },
    { 14, RGB_Color{ 129, 0, 0 } },
    { 15, RGB_Color{ 129, 86, 86 } },
    { 16, RGB_Color{ 104, 0, 0 } },
    { 17, RGB_Color{ 104, 69, 69 } },
    { 18, RGB_Color{ 79, 0, 0 } },
    { 19, RGB_Color{ 79, 53, 53 } },
    { 20, RGB_Color{ 255, 63, 0 } },
    { 21, RGB_Color{ 255, 191, 170 } },
    { 22, RGB_Color{ 189, 46, 0 } },
    { 23, RGB_Color{ 189, 141, 126 } },
    { 24, RGB_Color{ 129, 31, 0 } },
    { 25, RGB_Color{ 129, 96, 86 } },
    { 26, RGB_Color{ 104, 25, 0 } },
    { 27, RGB_Color{ 104, 78, 69 } },
    { 28, RGB_Color{ 79, 19, 0 } },
    { 29, RGB_Color{ 79, 59, 53 } },
    { 30, RGB_Color{ 255, 127, 0 } },
    { 31, RGB_Color{ 255, 212, 170 } },
    { 32, RGB_Color{ 189, 94, 0 } },
    { 33, RGB_Color{ 189, 157, 126 } },
    { 34, RGB_Color{ 129, 64, 0 } },
    { 35, RGB_Color{ 129, 107, 86 } },
    { 36, RGB_Color{ 104, 52, 0 } },
    { 37, RGB_Color{ 104, 86, 69 } },
    { 38, RGB_Color{ 79, 39, 0 } },
    { 39, RGB_Color{ 79, 66, 53 } },
    { 40, RGB_Color{ 255, 191, 0 } },
    { 41, RGB_Color{ 255, 234, 170 } },
    { 42, RGB_Color{ 189, 141, 0 } },
    { 43, RGB_Color{ 189, 173, 126 } },
    { 44, RGB_Color{ 129, 96, 0 } },
    { 45, RGB_Color{ 129, 118, 86 } },
    { 46, RGB_Color{ 104, 78, 0 } },
    { 47, RGB_Color{ 104, 95, 69 } },
    { 48, RGB_Color{ 79, 59, 0 } },
    { 49, RGB_Color{ 79, 73, 53 } },
    { 50, RGB_Color{ 255, 255, 0 } },
    { 51, RGB_Color{ 255, 255, 170 } },
    { 52, RGB_Color{ 189, 189, 0 } },
    { 53, RGB_Color{ 189, 189, 126 } },
    { 54, RGB_Color{ 129, 129, 0 } },
    { 55, RGB_Color{ 129, 129, 86 } },
    { 56, RGB_Color{ 104, 104, 0 } },
    { 57, RGB_Color{ 104, 104, 69 } },
    { 58, RGB_Color{ 79, 79, 0 } },
    { 59, RGB_Color{ 79, 79, 53 } },
    { 60, RGB_Color{ 191, 255, 0 } },
    { 61, RGB_Color{ 234, 255, 170 } },
    { 62, RGB_Color{ 141, 189, 0 } },
    { 63, RGB_Color{ 173, 189, 126 } },
    { 64, RGB_Color{ 96, 129, 0 } },
    { 65, RGB_Color{ 118, 129, 86 } },
    { 66, RGB_Color{ 78, 104, 0 } },
    { 67, RGB_Color{ 95, 104, 69 } },
    { 68, RGB_Color{ 59, 79, 0 } },
    { 69, RGB_Color{ 73, 79, 53 } },
    { 70, RGB_Color{ 127, 255, 0 } },
    { 71, RGB_Color{ 212, 255, 170 } },
    { 72, RGB_Color{ 94, 189, 0 } },
    { 73, RGB_Color{ 157, 189, 126 } },
    { 74, RGB_Color{ 64, 129, 0 } },
    { 75, RGB_Color{ 107, 129, 86 } },
    { 76, RGB_Color{ 52, 104, 0 } },
    { 77, RGB_Color{ 86, 104, 69 } },
    { 78, RGB_Color{ 39, 79, 0 } },
    { 79, RGB_Color{ 66, 79, 53 } },
    { 80, RGB_Color{ 63, 255, 0 } },
    { 81, RGB_Color{ 191, 255, 170 } },
    { 82, RGB_Color{ 46, 189, 0 } },
    { 83, RGB_Color{ 141, 189, 126 } },
    { 84, RGB_Color{ 31, 129, 0 } },
    { 85, RGB_Color{ 96, 129, 86 } },
    { 86, RGB_Color{ 25, 104, 0 } },
    { 87, RGB_Color{ 78, 104, 69 } },
    { 88, RGB_Color{ 19, 79, 0 } },
    { 89, RGB_Color{ 59, 79, 53 } },
    { 90, RGB_Color{ 0, 255, 0 } },
    { 91, RGB_Color{ 170, 255, 170 } },
    { 92, RGB_Color{ 0, 189, 0 } },
    { 93, RGB_Color{ 126, 189, 126 } },
    { 94, RGB_Color{ 0, 129, 0 } },
    { 95, RGB_Color{ 86, 129, 86 } },
    { 96, RGB_Color{ 0, 104, 0 } },
    { 97, RGB_Color{ 69, 104, 69 } },
    { 98, RGB_Color{ 0, 79, 0 } },
    { 99, RGB_Color{ 53, 79, 53 } },
    { 100, RGB_Color{ 0, 255, 63 } },
    { 101, RGB_Color{ 170, 255, 191 } },
    { 102, RGB_Color{ 0, 189, 46 } },
    { 103, RGB_Color{ 126, 189, 141 } },
    { 104, RGB_Color{ 0, 129, 31 } },
    { 105, RGB_Color{ 86, 129, 96 } },
    { 106, RGB_Color{ 0, 104, 25 } },
    { 107, RGB_Color{ 69, 104, 78 } },
    { 108, RGB_Color{ 0, 79, 19 } },
    { 109, RGB_Color{ 53, 79, 59 } },
    { 110, RGB_Color{ 0, 255, 127 } },
    { 111, RGB_Color{ 170, 255, 212 } },
    { 112, RGB_Color{ 0, 189, 94 } },
    { 113, RGB_Color{ 126, 189, 157 } },
    { 114, RGB_Color{ 0, 129, 64 } },
    { 115, RGB_Color{ 86, 129, 107 } },
    { 116, RGB_Color{ 0, 104, 52 } },
    { 117, RGB_Color{ 69, 104, 86 } },
    { 118, RGB_Color{ 0, 79, 39 } },
    { 119, RGB_Color{ 53, 79, 66 } },
    { 120, RGB_Color{ 0, 255, 191 } },
    { 121, RGB_Color{ 170, 255, 234 } },
    { 122, RGB_Color{ 0, 189, 141 } },
    { 123, RGB_Color{ 126, 189, 173 } },
    { 124, RGB_Color{ 0, 129, 96 } },
    { 125, RGB_Color{ 86, 129, 118 } },
    { 126, RGB_Color{ 0, 104, 78 } },
    { 127, RGB_Color{ 69, 104, 95 } },
    { 128, RGB_Color{ 0, 79, 59 } },
    { 129, RGB_Color{ 53, 79, 73 } },
    { 130, RGB_Color{ 0, 255, 255 } },
    { 131, RGB_Color{ 170, 255, 255 } },
    { 132, RGB_Color{ 0, 189, 189 } },
    { 133, RGB_Color{ 126, 189, 189 } },
    { 134, RGB_Color{ 0, 129, 129 } },
    { 135, RGB_Color{ 86, 129, 129 } },
    { 136, RGB_Color{ 0, 104, 104 } },
    { 137, RGB_Color{ 69, 104, 104 } },
    { 138, RGB_Color{ 0, 79, 79 } },
    { 139, RGB_Color{ 53, 79, 79 } },
    { 140, RGB_Color{ 0, 191, 255 } },
    { 141, RGB_Color{ 170, 234, 255 } },
    { 142, RGB_Color{ 0, 141, 189 } },
    { 143, RGB_Color{ 126, 173, 189 } },
    { 144, RGB_Color{ 0, 96, 129 } },
    { 145, RGB_Color{ 86, 118, 129 } },
    { 146, RGB_Color{ 0, 78, 104 } },
    { 147, RGB_Color{ 69, 95, 104 } },
    { 148, RGB_Color{ 0, 59, 79 } },
    { 149, RGB_Color{ 53, 73, 79 } },
    { 150, RGB_Color{ 0, 127, 255 } },
    { 151, RGB_Color{ 170, 212, 255 } },
    { 152, RGB_Color{ 0, 94, 189 } },
    { 153, RGB_Color{ 126, 157, 189 } },
    { 154, RGB_Color{ 0, 64, 129 } },
    { 155, RGB_Color{ 86, 107, 129 } },
    { 156, RGB_Color{ 0, 52, 104 } },
    { 157, RGB_Color{ 69, 86, 104 } },
    { 158, RGB_Color{ 0, 39, 79 } },
    { 159, RGB_Color{ 53, 66, 79 } },
    { 160, RGB_Color{ 0, 63, 255 } },
    { 161, RGB_Color{ 170, 191, 255 } },
    { 162, RGB_Color{ 0, 46, 189 } },
    { 163, RGB_Color{ 126, 141, 189 } },
    { 164, RGB_Color{ 0, 31, 129 } },
    { 165, RGB_Color{ 86, 96, 129 } },
    { 166, RGB_Color{ 0, 25, 104 } },
    { 167, RGB_Color{ 69, 78, 104 } },
    { 168, RGB_Color{ 0, 19, 79 } },
    { 169, RGB_Color{ 53, 59, 79 } },
    { 170, RGB_Color{ 0, 0, 255 } },
    { 171, RGB_Color{ 170, 170, 255 } },
    { 172, RGB_Color{ 0, 0, 189 } },
    { 173, RGB_Color{ 126, 126, 189 } },
    { 174, RGB_Color{ 0, 0, 129 } },
    { 175, RGB_Color{ 86, 86, 129 } },
    { 176, RGB_Color{ 0, 0, 104 } },
    { 177, RGB_Color{ 69, 69, 104 } },
    { 178, RGB_Color{ 0, 0, 79 } },
    { 179, RGB_Color{ 53, 53, 79 } },
    { 180, RGB_Color{ 63, 0, 255 } },
    { 181, RGB_Color{ 191, 170, 255 } },
    { 182, RGB_Color{ 46, 0, 189 } },
    { 183, RGB_Color{ 141, 126, 189 } },
    { 184, RGB_Color{ 31, 0, 129 } },
    { 185, RGB_Color{ 96, 86, 129 } },
    { 186, RGB_Color{ 25, 0, 104 } },
    { 187, RGB_Color{ 78, 69, 104 } },
    { 188, RGB_Color{ 19, 0, 79 } },
    { 189, RGB_Color{ 59, 53, 79 } },
    { 190, RGB_Color{ 127, 0, 255 } },
    { 191, RGB_Color{ 212, 170, 255 } },
    { 192, RGB_Color{ 94, 0, 189 } },
    { 193, RGB_Color{ 157, 126, 189 } },
    { 194, RGB_Color{ 64, 0, 129 } },
    { 195, RGB_Color{ 107, 86, 129 } },
    { 196, RGB_Color{ 52, 0, 104 } },
    { 197, RGB_Color{ 86, 69, 104 } },
    { 198, RGB_Color{ 39, 0, 79 } },
    { 199, RGB_Color{ 66, 53, 79 } },
    { 200, RGB_Color{ 191, 0, 255 } },
    { 201, RGB_Color{ 234, 170, 255 } },
    { 202, RGB_Color{ 141, 0, 189 } },
    { 203, RGB_Color{ 173, 126, 189 } },
    { 204, RGB_Color{ 96, 0, 129 } },
    { 205, RGB_Color{ 118, 86, 129 } },
    { 206, RGB_Color{ 78, 0, 104 } },
    { 207, RGB_Color{ 95, 69, 104 } },
    { 208, RGB_Color{ 59, 0, 79 } },
    { 209, RGB_Color{ 73, 53, 79 } },
    { 210, RGB_Color{ 255, 0, 255 } },
    { 211, RGB_Color{ 255, 170, 255 } },
    { 212, RGB_Color{ 189, 0, 189 } },
    { 213, RGB_Color{ 189, 126, 189 } },
    { 214, RGB_Color{ 129, 0, 129 } },
    { 215, RGB_Color{ 129, 86, 129 } },
    { 216, RGB_Color{ 104, 0, 104 } },
    { 217, RGB_Color{ 104, 69, 104 } },
    { 218, RGB_Color{ 79, 0, 79 } },
    { 219, RGB_Color{ 79, 53, 79 } },
    { 220, RGB_Color{ 255, 0, 191 } },
    { 221, RGB_Color{ 255, 170, 234 } },
    { 222, RGB_Color{ 189, 0, 141 } },
    { 223, RGB_Color{ 189, 126, 173 } },
    { 224, RGB_Color{ 129, 0, 96 } },
    { 225, RGB_Color{ 129, 86, 118 } },
    { 226, RGB_Color{ 104, 0, 78 } },
    { 227, RGB_Color{ 104, 69, 95 } },
    { 228, RGB_Color{ 79, 0, 59 } },
    { 229, RGB_Color{ 79, 53, 73 } },
    { 230, RGB_Color{ 255, 0, 127 } },
    { 231, RGB_Color{ 255, 170, 212 } },
    { 232, RGB_Color{ 189, 0, 94 } },
    { 233, RGB_Color{ 189, 126, 157 } },
    { 234, RGB_Color{ 129, 0, 64 } },
    { 235, RGB_Color{ 129, 86, 107 } },
    { 236, RGB_Color{ 104, 0, 52 } },
    { 237, RGB_Color{ 104, 69, 86 } },
    { 238, RGB_Color{ 79, 0, 39 } },
    { 239, RGB_Color{ 79, 53, 66 } },
    { 240, RGB_Color{ 255, 0, 63 } },
    { 241, RGB_Color{ 255, 170, 191 } },
    { 242, RGB_Color{ 189, 0, 46 } },
    { 243, RGB_Color{ 189, 126, 141 } },
    { 244, RGB_Color{ 129, 0, 31 } },
    { 245, RGB_Color{ 129, 86, 96 } },
    { 246, RGB_Color{ 104, 0, 25 } },
    { 247, RGB_Color{ 104, 69, 78 } },
    { 248, RGB_Color{ 79, 0, 19 } },
    { 249, RGB_Color{ 79, 53, 59 } },
    { 250, RGB_Color{ 51, 51, 51 } },
    { 251, RGB_Color{ 80, 80, 80 } },
    { 252, RGB_Color{ 105, 105, 105 } },
    { 253, RGB_Color{ 130, 130, 130 } },
    { 254, RGB_Color{ 190, 190, 190 } },
    { 255, RGB_Color{ 255, 255, 255 } },
};

} // namespace Mayo::IO
