from typing import Any, Dict

from typing import overload
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.std.chrono

class TCoords:
    decimal_value: float
    @overload
    def __init__(self, _deg: int, _min: int, _sec: float) -> None: ...
    @overload
    def __init__(self, dec: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCoords) -> None: ...
    def getAsString(self) -> str: ...
    @overload
    def getDecimalValue(self) -> float: ...
    @overload
    def getDecimalValue() -> double: ...
    def getDegMinSec(self, degrees: int, minutes: int, seconds: float) -> None: ...
    def setDegMinSec(self, degrees: int, minutes: int, seconds: float) -> None: ...
    @overload
    def setFromDecimal(self, dec: float) -> None: ...
    @overload
    def setFromDecimal(constdouble) -> void: ...

class TDatum10Params:
    Rx: float
    Ry: float
    Rz: float
    Xp: float
    Yp: float
    Zp: float
    dS: float
    dX: float
    dY: float
    dZ: float
    def __init__(self, _dX: float, _dY: float, _dZ: float, _Xp: float, _Yp: float, _Zp: float, _Rx: float, _Ry: float, _Rz: float, _dS: float) -> None: ...

class TDatum1DTransf:
    DZ: float
    dS: float
    dX: float
    dY: float
    def __init__(self, _dX: float, _dY: float, _DZ: float, _dS: float) -> None: ...

class TDatum7Params:
    Rx: float
    Ry: float
    Rz: float
    dS: float
    dX: float
    dY: float
    dZ: float
    def __init__(self, _dX: float, _dY: float, _dZ: float, _Rx: float, _Ry: float, _Rz: float, _dS: float) -> None: ...

class TDatum7Params_TOPCON:
    dS: float
    dX: float
    dY: float
    dZ: float
    m11: float
    m12: float
    m13: float
    m21: float
    m22: float
    m23: float
    m31: float
    m32: float
    m33: float
    def __init__(self, _dX: float, _dY: float, _dZ: float, _m11: float, _m12: float, _m13: float, _m21: float, _m22: float, _m23: float, _m31: float, _m32: float, _m33: float, _dS: float) -> None: ...

class TDatumHelmert2D:
    Xp: float
    Yp: float
    alpha: float
    dS: float
    dX: float
    dY: float
    def __init__(self, _dX: float, _dY: float, _alpha: float, _dS: float, _Xp: float, _Yp: float) -> None: ...

class TDatumHelmert2D_TOPCON:
    a: float
    b: float
    c: float
    d: float
    def __init__(self, _a: float, _b: float, _c: float, _d: float) -> None: ...

class TDatumHelmert3D:
    Rx: float
    Ry: float
    Rz: float
    dS: float
    dX: float
    dY: float
    dZ: float
    def __init__(self, _dX: float, _dY: float, _dZ: float, _Rx: float, _Ry: float, _Rz: float, _dS: float) -> None: ...

class TDatumHelmert3D_TOPCON:
    a: float
    b: float
    c: float
    d: float
    e: float
    f: float
    g: float
    def __init__(self, _a: float, _b: float, _c: float, _d: float, _e: float, _f: float, _g: float) -> None: ...

class TDatumTransfInterpolation:
    beta: float
    dSx: float
    dSy: float
    dX: float
    dY: float
    def __init__(self, _dX: float, _dY: float, _dSx: float, _dSy: float, _beta: float) -> None: ...

class TEllipsoid:
    name: str
    sa: float
    sb: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _sa: float, _sb: float, _name: str) -> None: ...
    @overload
    def __init__(self, arg0: TEllipsoid) -> None: ...
    def Ellipsoid_Airy_1830(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Airy_Modificado_1965(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Bessel_1841(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Clarke_1866(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Clarke_1880(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Fischer_1960(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Fischer_1968(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_GRS80(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Hayford_1909(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Helmert_1906(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Hough_1960(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Internacional_1909(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Internacional_1924(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Krasovsky_1940(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Mercury_1960(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Mercury_Modificado_1968(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Nuevo_Internacional_1967(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Sudamericano_1969(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_WGS66(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_WGS72(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_WGS84(self, *args, **kwargs) -> Any: ...
    def Ellipsoid_Walbeck_1817(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TEllipsoid: ...

class TGeodeticCoords:
    height: float
    lat: TCoords
    lon: TCoords
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _lat: float, _lon: float, _height: float) -> None: ...
    @overload
    def isClear(self) -> bool: ...
    @overload
    def isClear() -> bool: ...

class TPathFromRTKInfo:
    W_star: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
    best_gps_path: Any
    mahalabis_quality_measure: Dict[mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t,float]
    vehicle_uncertainty: Dict[mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t,mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TPathFromRTKInfo) -> None: ...
    def assign(self) -> TPathFromRTKInfo: ...

def ENUToGeocentric(in_ENU_point, in_coords_origin: TGeodeticCoords, out_coords, ellip: TEllipsoid) -> None: ...
@overload
def ENU_axes_from_WGS84(in_longitude_reference_degrees: float, in_latitude_reference_degrees: float, in_height_reference_meters: float, out_ENU: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
@overload
def ENU_axes_from_WGS84(in_longitude_reference_degrees: float, in_latitude_reference_degrees: float, in_height_reference_meters: float, out_ENU: mrpt.pymrpt.mrpt.math.TPose3D, only_angles: bool) -> None: ...
@overload
def ENU_axes_from_WGS84(in_coords: TGeodeticCoords, out_ENU: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
@overload
def ENU_axes_from_WGS84(in_coords: TGeodeticCoords, out_ENU: mrpt.pymrpt.mrpt.math.TPose3D, only_angles: bool) -> None: ...
@overload
def ENU_axes_from_WGS84(conststructmrpt, structmrpt, bool) -> void: ...
@overload
def GeodeticToUTM(in_latitude_degrees: float, in_longitude_degrees: float, out_UTM_x: float, out_UTM_y: float, out_UTM_zone: int, out_UTM_latitude_band: str) -> None: ...
@overload
def GeodeticToUTM(in_latitude_degrees: float, in_longitude_degrees: float, out_UTM_x: float, out_UTM_y: float, out_UTM_zone: int, out_UTM_latitude_band: str, ellip: TEllipsoid) -> None: ...
@overload
def GeodeticToUTM(GeodeticCoords: TGeodeticCoords, UTMCoords, UTMZone: int, UTMLatitudeBand: str) -> None: ...
@overload
def GeodeticToUTM(GeodeticCoords: TGeodeticCoords, UTMCoords, UTMZone: int, UTMLatitudeBand: str, ellip: TEllipsoid) -> None: ...
@overload
def UTMToGeodetic(X: float, Y: float, zone: int, hem: str, out_lon: float, out_lat: float) -> None: ...
@overload
def UTMToGeodetic(X: float, Y: float, zone: int, hem: str, out_lon: float, out_lat: float, ellip: TEllipsoid) -> None: ...
@overload
def UTMToGeodetic(UTMCoords, zone: int, hem: str, GeodeticCoords: TGeodeticCoords) -> None: ...
@overload
def UTMToGeodetic(UTMCoords, zone: int, hem: str, GeodeticCoords: TGeodeticCoords, ellip: TEllipsoid) -> None: ...
def geocentricToENU_WGS84(in_geocentric_point, out_ENU_point, in_coords_origin: TGeodeticCoords) -> None: ...
@overload
def geocentricToGeodetic(in_point, out_coords: TGeodeticCoords) -> None: ...
@overload
def geocentricToGeodetic(in_point, out_coords: TGeodeticCoords, ellip: TEllipsoid) -> None: ...
def geodeticToENU_WGS84(in_coords: TGeodeticCoords, out_ENU_point, in_coords_origin: TGeodeticCoords) -> None: ...
def geodeticToGeocentric(in_coords: TGeodeticCoords, out_point, ellip: TEllipsoid) -> None: ...
def geodeticToGeocentric_WGS84(*args, **kwargs) -> Any: ...
@overload
def geodeticToUTM(GeodeticCoords: TGeodeticCoords, UTMCoords, UTMZone: int, UTMLatitudeBand: str) -> None: ...
@overload
def geodeticToUTM(GeodeticCoords: TGeodeticCoords, UTMCoords, UTMZone: int, UTMLatitudeBand: str, ellip: TEllipsoid) -> None: ...
@overload
def path_from_rtk_gps(robot_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator, rawlog: mrpt.pymrpt.mrpt.obs.CRawlog, rawlog_first: int, rawlog_last: int) -> None: ...
@overload
def path_from_rtk_gps(robot_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator, rawlog: mrpt.pymrpt.mrpt.obs.CRawlog, rawlog_first: int, rawlog_last: int, isGUI: bool) -> None: ...
@overload
def path_from_rtk_gps(robot_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator, rawlog: mrpt.pymrpt.mrpt.obs.CRawlog, rawlog_first: int, rawlog_last: int, isGUI: bool, disableGPSInterp: bool) -> None: ...
@overload
def path_from_rtk_gps(robot_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator, rawlog: mrpt.pymrpt.mrpt.obs.CRawlog, rawlog_first: int, rawlog_last: int, isGUI: bool, disableGPSInterp: bool, path_smooth_filter_size: int) -> None: ...
@overload
def path_from_rtk_gps(robot_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator, rawlog: mrpt.pymrpt.mrpt.obs.CRawlog, rawlog_first: int, rawlog_last: int, isGUI: bool, disableGPSInterp: bool, path_smooth_filter_size: int, outInfo: TPathFromRTKInfo) -> None: ...
def transfInterpolation(p, d: TDatumTransfInterpolation, o) -> None: ...
def transform10params(*args, **kwargs) -> Any: ...
def transform1D(p, d: TDatum1DTransf, o) -> None: ...
def transform7params(*args, **kwargs) -> Any: ...
def transform7params_TOPCON(in_point, in_datum: TDatum7Params_TOPCON, out_point) -> None: ...
def transformHelmert2D(*args, **kwargs) -> Any: ...
def transformHelmert2D_TOPCON(p, d: TDatumHelmert2D_TOPCON, o) -> None: ...
def transformHelmert3D(*args, **kwargs) -> Any: ...
def transformHelmert3D_TOPCON(p, d: TDatumHelmert3D_TOPCON, o) -> None: ...
