/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.PermissionsAction;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.ChatChannel;
import org.chefproject.core.ChatMessage;
import org.chefproject.core.Edit;
import org.chefproject.core.Filter;
import org.chefproject.core.MessageChannelEdit;
import org.chefproject.core.MessageEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.core.component.FocusDelivery;
import org.chefproject.core.component.RefreshDelivery;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.ChatService;
import org.chefproject.service.CourierService;
import org.chefproject.service.PortalService;
import org.chefproject.service.PresenceService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.ChatObservingCourier;
import org.chefproject.util.ColorMapper;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.PresenceObservingCourier;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.TimeBreakdown;
import org.chefproject.util.Validator;

public class ChatAction
extends VelocityPortletPaneledAction {
    private static final String PARAM_CHANNEL = "channel";
    private static final String PARAM_DISPLAY_DATE = "display-date";
    private static final String PARAM_DISPLAY_TIME = "display-time";
    private static final String PARAM_DISPLAY_USER = "display-user";
    private static final String PARAM_SOUND_ALERT = "sound-alert";
    private static final String PARAM_MEMBER_FILTER = "member-filter";
    private static final String PARAM_FILTER_TYPE = "filter-type";
    private static final String PARAM_FILTER_PARAM = "filter-param";
    private static final String FORM_CHANNEL = "channel";
    private static final String FORM_NEW_CHANNEL = "new-channel";
    private static final String FORM_FILTER_TYPE = "filter-type";
    private static final String FORM_FILTER_PARAM_DAYS = "filter-param-days";
    private static final String FORM_FILTER_PARAM_NUMBER = "filter-param-number";
    private static final String FILTER_BY_NUMBER = "SelectMessagesByNumber";
    private static final String FILTER_BY_TIME = "SelectMessagesByTime";
    private static final String FILTER_TODAY = "SelectTodaysMessages";
    private static final String FILTER_ALL = "SelectAllMessages";
    private static final String[] ALL_FILTERS;
    private static final int DEFAULT_PARAM = 0;
    private static final int DEFAULT_DAYS = 3;
    private static final int DEFAULT_MSGS = 12;
    private static final String FORM_MESSAGE = "message";
    private static final String MONITOR_PANEL = "List";
    private static final String CONTROL_PANEL = "Control";
    private static final String PRESENCE_PANEL = "Presence";
    private static final String TOOLBAR_PANEL = "Toolbar";
    private static final String STATE_CHANNEL_REF = "channelId";
    private static final String STATE_SITE = "siteId";
    private static final String STATE_DISPLAY_DATE = "display-date";
    private static final String STATE_DISPLAY_TIME = "display-time";
    private static final String STATE_DISPLAY_USER = "display-user";
    private static final String STATE_SOUND_ALERT = "sound-alert";
    private static final String STATE_UPDATE = "update";
    private static final String STATE_CHANNEL_PROBLEM = "channel-problem";
    private static final String STATE_FILTER_TYPE = "filter-type";
    private static final String STATE_FILTER_PARAM = "filter-param";
    private static final String STATE_MESSAGE_FILTER = "message-filter";
    private static final String STATE_MORE_SELECTED = "more-selected";
    private static final String STATE_MORE_MESSAGES_LABEL = "more-messages-label";
    private static final String STATE_MORE_MESSAGES_FILTER = "more-messages-filter";
    private static final String STATE_FEWER_MESSAGES_LABEL = "fewer-messages-label";
    private static final String STATE_FEWER_MESSAGES_FILTER = "fewer-messages-filter";
    private static final String STATE_BROWSER = "browser";
    private static final String STATE_CHAT_PRESENCE_OBSERVER = "obsever2";
    private static final String STATE_COLOR_MAPPER = "color-mapper";
    private static final String NEW_CHAT_CHANNEL = "new-chat-channel";
    private static final String CHANNEL_MISSING = "This chat is not available.";
    private static final String CHANNEL_PERMISSION = "You do not have permission to view this chat.";
    private static final String CHANNEL_CREATE_PERMISSION = "You do not have permission to create this chat.";
    private static final String PERMISSION_POST_MESSAGE = "You do not have permission to post to this chat.";
    private static final String POST_PROBLEM_MESSAGE = "There was a problem sending the prior message.";

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute(STATE_CHANNEL_REF) == null) {
            String elementId;
            String deliveryId;
            PortletConfig config = portlet.getPortletConfig();
            String channel = StringUtil.trimToNull(config.getInitParameter("channel"));
            if (channel == null) {
                channel = ChatService.channelReference(PortalService.getCurrentSiteId(), "main");
            }
            state.setAttribute(STATE_CHANNEL_REF, (Object)channel);
            if (state.getAttribute("display-date") == null) {
                state.setAttribute("display-date", (Object)new Boolean(config.getInitParameter("display-date")));
            }
            if (state.getAttribute("display-time") == null) {
                state.setAttribute("display-time", (Object)new Boolean(config.getInitParameter("display-time")));
            }
            if (state.getAttribute("display-user") == null) {
                state.setAttribute("display-user", (Object)new Boolean(config.getInitParameter("display-user")));
            }
            if (state.getAttribute("sound-alert") == null) {
                state.setAttribute("sound-alert", (Object)new Boolean(config.getInitParameter("sound-alert")));
            }
            if (state.getAttribute(STATE_COLOR_MAPPER) == null) {
                ColorMapper mapper = new ColorMapper();
                mapper.getColor(UsageSessionService.getSessionUser().getDisplayName());
                state.setAttribute(STATE_COLOR_MAPPER, (Object)mapper);
            }
            if (state.getAttribute("filter-type") == null) {
                String filter_type = config.getInitParameter("filter-type", FILTER_BY_TIME);
                String filter_param = config.getInitParameter("filter-param", String.valueOf(3));
                this.updateMessageFilters(state, filter_type, filter_param);
            }
            if (state.getAttribute("obsever") == null) {
                deliveryId = this.clientWindowId(state, portlet.getID());
                elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID()) + "." + MONITOR_PANEL;
                Reference r = new Reference(channel);
                String pattern = ChatService.messageReference(r.getContext(), r.getId(), "");
                boolean wantsBeeps = (Boolean)state.getAttribute("sound-alert");
                state.setAttribute("obsever", (Object)new ChatObservingCourier(deliveryId, elementId, pattern, wantsBeeps));
            }
            if (state.getAttribute(STATE_CHAT_PRESENCE_OBSERVER) == null) {
                deliveryId = PortalService.getCurrentClientWindowId();
                elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID()) + "." + PRESENCE_PANEL;
                String location = PortalService.getCurrentLocationId(portlet.getID());
                PresenceObservingCourier observer2 = new PresenceObservingCourier(deliveryId, elementId, location);
                state.setAttribute(STATE_CHAT_PRESENCE_OBSERVER, (Object)observer2);
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", (Object)((Object)this) + ": observer: " + observer2 + " elementId: " + elementId + " deliveryAddress: " + deliveryId + " location: " + location);
                }
            }
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        String channel = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference r = new Reference(channel);
        String pattern = ChatService.messageReference(r.getContext(), r.getId(), "");
        String deliveryId = this.clientWindowId(state, peid);
        ChatObservingCourier observer1 = (ChatObservingCourier)state.getAttribute("obsever");
        observer1.setResourcePattern(pattern);
        observer1.setDeliveryId(deliveryId);
        PresenceObservingCourier observer2 = (PresenceObservingCourier)state.getAttribute(STATE_CHAT_PRESENCE_OBSERVER);
        observer2.setDeliveryId(deliveryId);
    }

    private void updateMessageFilters(SessionState state, String filter_type, String filter_param) {
        state.setAttribute(STATE_MORE_MESSAGES_LABEL, (Object)"Show All Messages");
        state.setAttribute(STATE_MORE_MESSAGES_FILTER, (Object)new SelectAllMessages());
        state.setAttribute("filter-param", (Object)String.valueOf(0));
        state.setAttribute(STATE_MORE_SELECTED, (Object)new Boolean(false));
        state.setAttribute("filter-type", (Object)filter_type);
        if (filter_type.equals(FILTER_ALL)) {
            state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectMessagesByTime(3));
            state.setAttribute(STATE_FEWER_MESSAGES_LABEL, (Object)"Show Past 3 Days");
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_MORE_MESSAGES_FILTER));
            state.setAttribute(STATE_MORE_SELECTED, (Object)new Boolean(true));
        } else if (filter_type.equals(FILTER_TODAY)) {
            state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectTodaysMessages());
            state.setAttribute(STATE_FEWER_MESSAGES_LABEL, (Object)"Show Today's Messages");
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_FEWER_MESSAGES_FILTER));
        } else if (filter_type.equals(FILTER_BY_NUMBER)) {
            int number = 12;
            try {
                number = Integer.parseInt(filter_param);
                if (number <= 0) {
                    throw new Exception();
                }
                state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectMessagesByNumber(number, state));
                state.setAttribute("filter-param", (Object)filter_param);
            }
            catch (Exception e) {
                Log.warn("chef", (Object)((Object)this) + ".updateMessageFilters() invalid param: ");
            }
            state.setAttribute("filter-param", (Object)String.valueOf(number));
            state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectMessagesByNumber(number, state));
            state.setAttribute(STATE_FEWER_MESSAGES_LABEL, (Object)("Show Last " + number + " Messages"));
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_FEWER_MESSAGES_FILTER));
        } else if (filter_type.equals(FILTER_BY_TIME)) {
            int number = 3;
            try {
                number = Integer.parseInt(filter_param);
                if (number <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                Log.warn("chef", (Object)((Object)this) + ".updateMessageFilters() invalid param: ");
            }
            state.setAttribute("filter-param", (Object)String.valueOf(number));
            state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectMessagesByTime(number));
            state.setAttribute(STATE_FEWER_MESSAGES_LABEL, (Object)("Show Past " + number + " Days"));
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_FEWER_MESSAGES_FILTER));
        } else {
            state.setAttribute("filter-param", (Object)String.valueOf(3));
            state.setAttribute(STATE_FEWER_MESSAGES_FILTER, (Object)new SelectMessagesByTime(3));
            state.setAttribute(STATE_FEWER_MESSAGES_LABEL, (Object)"Show Past 3 Days");
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_FEWER_MESSAGES_FILTER));
        }
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String mode;
        String helperMode = (String)state.getAttribute("pemissions.mode");
        if (helperMode != null) {
            String template = PermissionsAction.buildHelperContext(portlet, context, rundata, state);
            if (template == null) {
                this.addAlert(state, "There is a problem setting Permissions at this time.");
            } else {
                return template;
            }
        }
        if ("options".equals(mode = (String)state.getAttribute("mode"))) {
            return this.buildOptionsPanelContext(portlet, context, rundata, state);
        }
        Vector<String> focus_elements = new Vector<String>();
        focus_elements.add(CONTROL_PANEL);
        focus_elements.add(FORM_MESSAGE);
        context.put("focus_path", focus_elements);
        context.put("panel-control", CONTROL_PANEL);
        context.put("panel-monitor", MONITOR_PANEL);
        context.put("panel-presence", PRESENCE_PANEL);
        context.put("panel-toolbar", TOOLBAR_PANEL);
        return (String)this.getContext(rundata).get("template") + "-Layout";
    }

    public void doToggle_date_display(RunData runData, Context context) {
        this.toggleState(runData, "display-date");
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String address = ((ChatObservingCourier)state.getAttribute("obsever")).getDeliveryId();
        String elementID = ((ChatObservingCourier)state.getAttribute("obsever")).getElementId();
        CourierService.deliver(address, elementID);
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        String[] focusPath = new String[]{mainPanelId, CONTROL_PANEL, FORM_MESSAGE};
        CourierService.deliver(new FocusDelivery(address, focusPath));
    }

    public void doToggle_time_display(RunData runData, Context context) {
        this.toggleState(runData, "display-time");
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String address = ((ChatObservingCourier)state.getAttribute("obsever")).getDeliveryId();
        String elementID = ((ChatObservingCourier)state.getAttribute("obsever")).getElementId();
        CourierService.deliver(new RefreshDelivery(address, elementID));
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        String[] focusPath = new String[]{mainPanelId, CONTROL_PANEL, FORM_MESSAGE};
        CourierService.deliver(new FocusDelivery(address, focusPath));
    }

    public void doToggle_user_display(RunData runData, Context context) {
        this.toggleState(runData, "display-user");
    }

    public void doToggle_sound_alert(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        boolean newValue = (Boolean)state.getAttribute("sound-alert") == false;
        state.setAttribute("sound-alert", (Object)new Boolean(newValue));
        ChatObservingCourier observer = (ChatObservingCourier)state.getAttribute("obsever");
        observer.alertEnabled(newValue);
        String address = ((ChatObservingCourier)state.getAttribute("obsever")).getDeliveryId();
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        String[] focusPath = new String[]{mainPanelId, CONTROL_PANEL, FORM_MESSAGE};
        CourierService.deliver(new FocusDelivery(address, focusPath));
    }

    private void toggleState(RunData runData, String stateName) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        boolean newValue = (Boolean)state.getAttribute(stateName) == false;
        state.setAttribute(stateName, (Object)new Boolean(newValue));
    }

    public void doToggle_filter(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        if (((Boolean)state.getAttribute(STATE_MORE_SELECTED)).booleanValue()) {
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_FEWER_MESSAGES_FILTER));
        } else {
            state.setAttribute(STATE_MESSAGE_FILTER, state.getAttribute(STATE_MORE_MESSAGES_FILTER));
        }
        this.toggleState(runData, STATE_MORE_SELECTED);
        String address = ((ChatObservingCourier)state.getAttribute("obsever")).getDeliveryId();
        String elementID = ((ChatObservingCourier)state.getAttribute("obsever")).getElementId();
        CourierService.deliver(address, elementID);
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        String[] focusPath = new String[]{mainPanelId, CONTROL_PANEL, FORM_MESSAGE};
        CourierService.deliver(new FocusDelivery(address, focusPath));
    }

    public String buildToolbarPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        Menu bar = new Menu((Portlet)portlet, rundata, (String)state.getAttribute("action"));
        boolean displayDate = (Boolean)state.getAttribute("display-date");
        bar.add(new MenuEntry(displayDate ? "Hide Date" : "Show Date", null, true, displayDate ? 2 : 1, "doToggle_date_display"));
        boolean displayTime = (Boolean)state.getAttribute("display-time");
        bar.add(new MenuEntry(displayTime ? "Hide Time" : "Show Time", null, true, displayTime ? 2 : 1, "doToggle_time_display"));
        boolean soundAlert = (Boolean)state.getAttribute("sound-alert");
        bar.add(new MenuEntry(soundAlert ? "Turn OFF New Message Alert" : "Turn ON New Message Alert", null, true, soundAlert ? 2 : 1, "doToggle_sound_alert"));
        boolean moreSelected = (Boolean)state.getAttribute(STATE_MORE_SELECTED);
        bar.add(new MenuEntry(moreSelected ? (String)state.getAttribute(STATE_FEWER_MESSAGES_LABEL) : (String)state.getAttribute(STATE_MORE_MESSAGES_LABEL), null, true, moreSelected ? 2 : 1, "doToggle_filter"));
        this.addOptionsMenu(bar, (JetspeedRunData)rundata);
        if (SiteService.allowUpdateSite(PortalService.getCurrentSiteId())) {
            bar.add(new MenuEntry("Permissions...", "doPermissions"));
        }
        context.put("menu", bar);
        context.put("action", state.getAttribute("action"));
        return null;
    }

    public String buildListPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("display_date", state.getAttribute("display-date"));
        context.put("display_time", state.getAttribute("display-time"));
        context.put("display_user", state.getAttribute("display-user"));
        context.put("sound_alert", state.getAttribute("sound-alert"));
        context.put("color_mapper", (ColorMapper)state.getAttribute(STATE_COLOR_MAPPER));
        try {
            ChatChannel channel = ChatService.getChatChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            Filter filter = (Filter)state.getAttribute(STATE_MESSAGE_FILTER);
            context.put("chat_messages", channel.getMessages(filter, true));
        }
        catch (PermissionException e) {
            context.put(FORM_MESSAGE, CHANNEL_PERMISSION);
        }
        catch (IdUnusedException e) {
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".buildListPanelContext()", (Throwable)e);
        }
        ((ChatObservingCourier)state.getAttribute("obsever")).justDelivered();
        return null;
    }

    public String buildControlPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("panel-control", CONTROL_PANEL);
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doSend");
        context.put("form-message", FORM_MESSAGE);
        boolean allowed = false;
        ChatChannel channel = null;
        try {
            channel = ChatService.getChatChannel((String)state.getAttribute(STATE_CHANNEL_REF));
        }
        catch (IdUnusedException ignore) {
        }
        catch (PermissionException ignore) {
            // empty catch block
        }
        allowed = channel != null ? channel.allowAddMessage() : ChatService.allowAddChannel((String)state.getAttribute(STATE_CHANNEL_REF));
        Boolean allow = new Boolean(allowed);
        if (!allowed) {
            context.put(FORM_MESSAGE, PERMISSION_POST_MESSAGE);
        }
        context.put("allow-send", allow);
        return null;
    }

    public String buildPresencePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        Object template = null;
        PresenceObservingCourier observer = (PresenceObservingCourier)state.getAttribute(STATE_CHAT_PRESENCE_OBSERVER);
        String location = PortalService.getCurrentLocationId(portlet.getID());
        List sessions = PresenceService.getPresence(location);
        context.put("sessions", sessions);
        observer.justDelivered();
        return null;
    }

    public void doSend(RunData runData, Context context) {
        Edit edit;
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String message = runData.getParameters().getString(FORM_MESSAGE);
        if ((message = message.replace('\r', ' ').replace('\n', ' ')) == null || message.length() == 0) {
            return;
        }
        Resource channel = null;
        try {
            channel = ChatService.getChatChannel((String)state.getAttribute(STATE_CHANNEL_REF));
        }
        catch (IdUnusedException ignore) {
        }
        catch (PermissionException ignore) {
            // empty catch block
        }
        if (channel == null && state.getAttribute(STATE_CHANNEL_PROBLEM) == null) {
            try {
                edit = ChatService.addChatChannel((String)state.getAttribute(STATE_CHANNEL_REF));
                ChatService.commitChannel((MessageChannelEdit)edit);
                channel = edit;
            }
            catch (IdUsedException e) {
                try {
                    channel = ChatService.getChatChannel((String)state.getAttribute(STATE_CHANNEL_REF));
                }
                catch (IdUnusedException ignore) {
                }
                catch (PermissionException ignore) {}
            }
            catch (IdInvalidException e) {
                state.setAttribute(STATE_CHANNEL_PROBLEM, (Object)CHANNEL_MISSING);
                Log.warn("chef", (Object)((Object)this) + ".doSend(): creating channel: ", (Throwable)e);
            }
            catch (PermissionException e) {
                state.setAttribute(STATE_CHANNEL_PROBLEM, (Object)CHANNEL_CREATE_PERMISSION);
            }
        }
        if (channel != null) {
            try {
                edit = channel.addChatMessage();
                edit.setBody(message);
                channel.commitMessage((MessageEdit)edit);
            }
            catch (PermissionException e) {
                this.addAlert(state, PERMISSION_POST_MESSAGE);
            }
            catch (Exception e) {
                this.addAlert(state, POST_PROBLEM_MESSAGE);
                Log.warn("chef", (Object)((Object)this) + ".doSend()", (Throwable)e);
            }
        } else {
            this.addAlert(state, (String)state.getAttribute(STATE_CHANNEL_PROBLEM));
        }
        String address = ((ChatObservingCourier)state.getAttribute("obsever")).getDeliveryId();
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        String[] focusPath = new String[]{mainPanelId, CONTROL_PANEL, FORM_MESSAGE};
        CourierService.deliver(new FocusDelivery(address, focusPath));
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("filter_type", (String)state.getAttribute("filter-type"));
        context.put("filter_type_form", "filter-type");
        context.put("filter_days_param", (String)state.getAttribute("filter-param"));
        context.put("filter_days_param_form", FORM_FILTER_PARAM_DAYS);
        context.put("filter_number_param", (String)state.getAttribute("filter-param"));
        context.put("filter_number_param_form", FORM_FILTER_PARAM_NUMBER);
        context.put("default_chat_channel", "main");
        String siteID = PortalService.getCurrentSiteId();
        String defaultChannel = ChatService.channelReference(siteID, "main");
        String sitePrefix = defaultChannel.substring(0, defaultChannel.lastIndexOf("main"));
        String currentChannel = ((String)state.getAttribute(STATE_CHANNEL_REF)).substring(sitePrefix.length());
        context.put("chat_channel", currentChannel);
        Iterator aChannel = ChatService.getChannels().iterator();
        Vector<String> channel_list = new Vector<String>();
        while (aChannel.hasNext()) {
            ChatChannel theChannel = (ChatChannel)aChannel.next();
            if (!theChannel.getContext().equals(siteID) || theChannel.getId().equals("main") || theChannel.getId().equals(currentChannel)) continue;
            channel_list.add(theChannel.getId());
        }
        context.put("chat_channels", channel_list);
        context.put("new_chat_channel", NEW_CHAT_CHANNEL);
        context.put("form_new_channel", FORM_NEW_CHANNEL);
        context.put("chat_channel_form", "channel");
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doUpdate");
        context.put("form-cancel", "eventSubmit_doCancel");
        String template = (String)this.getContext(rundata).get("template");
        return template + "-customize";
    }

    public void doUpdate(RunData data, Context context) {
        String filter_type;
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        String siteID = PortalService.getCurrentSiteId();
        String newChannel = data.getParameters().getString("channel");
        String currentChannel = ((String)state.getAttribute(STATE_CHANNEL_REF)).substring(siteID.length() + 1);
        if (newChannel != null && newChannel.equals(NEW_CHAT_CHANNEL)) {
            newChannel = data.getParameters().getString(FORM_NEW_CHANNEL);
            try {
                Validator.checkResourceId(newChannel);
            }
            catch (IdInvalidException e) {
                this.addAlert(state, "You entered \"" + newChannel + "\" for Chat room name. Chat room name" + e.getMessage());
                return;
            }
        }
        if (newChannel != null && !newChannel.equals(currentChannel)) {
            state.setAttribute(STATE_CHANNEL_REF, (Object)ChatService.channelReference(siteID, newChannel));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", (Object)((Object)this) + ".doUpdate(): newChannel: " + newChannel);
            }
            this.updateObservationOfChannel(state, peid);
            ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
            tool.getPropertiesEdit().addProperty("channel", (String)state.getAttribute(STATE_CHANNEL_REF));
        }
        if ((filter_type = data.getParameters().getString("filter-type")) != null) {
            String filter_number_param;
            if (filter_type.equals(FILTER_ALL)) {
                if (!filter_type.equals((String)state.getAttribute("filter-type"))) {
                    this.updateMessageFilters(state, filter_type, null);
                    ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
                    tool.getPropertiesEdit().addProperty("filter-type", (String)state.getAttribute("filter-type"));
                    tool.getPropertiesEdit().addProperty("filter-param", (String)state.getAttribute("filter-param"));
                }
            } else if (filter_type.equals(FILTER_BY_TIME)) {
                String filter_days_param = data.getParameters().getString(FORM_FILTER_PARAM_DAYS);
                if (!(filter_days_param == null || filter_type.equals((String)state.getAttribute("filter-type")) && filter_days_param.equals((String)state.getAttribute("filter-param")))) {
                    this.updateMessageFilters(state, filter_type, filter_days_param);
                    ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
                    tool.getPropertiesEdit().addProperty("filter-type", (String)state.getAttribute("filter-type"));
                    tool.getPropertiesEdit().addProperty("filter-param", (String)state.getAttribute("filter-param"));
                }
            } else if (!(!filter_type.equals(FILTER_BY_NUMBER) || (filter_number_param = data.getParameters().getString(FORM_FILTER_PARAM_NUMBER)) == null || filter_type.equals((String)state.getAttribute("filter-type")) && filter_number_param.equals((String)state.getAttribute("filter-param")))) {
                this.updateMessageFilters(state, filter_type, filter_number_param);
                ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
                tool.getPropertiesEdit().addProperty("filter-type", (String)state.getAttribute("filter-type"));
                tool.getPropertiesEdit().addProperty("filter-param", (String)state.getAttribute("filter-param"));
            }
        }
        state.removeAttribute("mode");
        VelocityPortletPaneledAction.enableObservers(state);
        this.saveOptions();
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.removeAttribute("mode");
        VelocityPortletPaneledAction.enableObservers(state);
        this.cancelOptions();
    }

    protected boolean requireResetToolLink() {
        return false;
    }

    public void doPermissions(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String channelRefStr = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference channelRef = new Reference(channelRefStr);
        String siteRef = SiteService.siteReference(channelRef.getContext());
        state.setAttribute("permission.realmId", (Object)siteRef);
        state.setAttribute("permission.realmRolesId", (Object)siteRef);
        state.setAttribute("permission.description", (Object)("Set permissions for Chat in worksite " + SiteService.getSiteDisplay(channelRef.getContext())));
        state.setAttribute("permission.prefix", (Object)"chat.");
        state.setAttribute("pemissions.mode", (Object)"main");
        String toolId = PortalService.getCurrentToolId();
        String address = this.clientWindowId(state, toolId);
        String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(toolId);
        CourierService.deliver(address, mainPanelId);
    }

    static {
        PARAM_CHANNEL = "channel";
        PARAM_DISPLAY_DATE = "display-date";
        PARAM_DISPLAY_TIME = "display-time";
        PARAM_DISPLAY_USER = "display-user";
        PARAM_SOUND_ALERT = "sound-alert";
        PARAM_MEMBER_FILTER = PARAM_MEMBER_FILTER;
        PARAM_FILTER_TYPE = "filter-type";
        PARAM_FILTER_PARAM = "filter-param";
        FORM_CHANNEL = "channel";
        FORM_NEW_CHANNEL = FORM_NEW_CHANNEL;
        FORM_FILTER_TYPE = "filter-type";
        FORM_FILTER_PARAM_DAYS = FORM_FILTER_PARAM_DAYS;
        FORM_FILTER_PARAM_NUMBER = FORM_FILTER_PARAM_NUMBER;
        FILTER_BY_NUMBER = FILTER_BY_NUMBER;
        FILTER_BY_TIME = FILTER_BY_TIME;
        FILTER_TODAY = FILTER_TODAY;
        FILTER_ALL = FILTER_ALL;
        ALL_FILTERS = new String[]{FILTER_BY_NUMBER, FILTER_BY_TIME, FILTER_TODAY, FILTER_ALL};
        DEFAULT_PARAM = 0;
        DEFAULT_DAYS = 3;
        DEFAULT_MSGS = 12;
        FORM_MESSAGE = FORM_MESSAGE;
        MONITOR_PANEL = MONITOR_PANEL;
        CONTROL_PANEL = CONTROL_PANEL;
        PRESENCE_PANEL = PRESENCE_PANEL;
        TOOLBAR_PANEL = TOOLBAR_PANEL;
        STATE_CHANNEL_REF = STATE_CHANNEL_REF;
        STATE_SITE = STATE_SITE;
        STATE_DISPLAY_DATE = "display-date";
        STATE_DISPLAY_TIME = "display-time";
        STATE_DISPLAY_USER = "display-user";
        STATE_SOUND_ALERT = "sound-alert";
        STATE_UPDATE = STATE_UPDATE;
        STATE_CHANNEL_PROBLEM = STATE_CHANNEL_PROBLEM;
        STATE_FILTER_TYPE = "filter-type";
        STATE_FILTER_PARAM = "filter-param";
        STATE_MESSAGE_FILTER = STATE_MESSAGE_FILTER;
        STATE_MORE_SELECTED = STATE_MORE_SELECTED;
        STATE_MORE_MESSAGES_LABEL = STATE_MORE_MESSAGES_LABEL;
        STATE_MORE_MESSAGES_FILTER = STATE_MORE_MESSAGES_FILTER;
        STATE_FEWER_MESSAGES_LABEL = STATE_FEWER_MESSAGES_LABEL;
        STATE_FEWER_MESSAGES_FILTER = STATE_FEWER_MESSAGES_FILTER;
        STATE_BROWSER = STATE_BROWSER;
        STATE_CHAT_PRESENCE_OBSERVER = STATE_CHAT_PRESENCE_OBSERVER;
        STATE_COLOR_MAPPER = STATE_COLOR_MAPPER;
        NEW_CHAT_CHANNEL = NEW_CHAT_CHANNEL;
        CHANNEL_MISSING = CHANNEL_MISSING;
        CHANNEL_PERMISSION = CHANNEL_PERMISSION;
        CHANNEL_CREATE_PERMISSION = CHANNEL_CREATE_PERMISSION;
        PERMISSION_POST_MESSAGE = PERMISSION_POST_MESSAGE;
        POST_PROBLEM_MESSAGE = POST_PROBLEM_MESSAGE;
    }

    private class SelectTodaysMessages
    implements Filter {
        private Time m_cutoff = null;

        public SelectTodaysMessages() {
            TimeBreakdown now = new Time(System.currentTimeMillis()).breakdownLocal();
            this.m_cutoff = new Time("LocalTime", now.getYear(), now.getMonth(), now.getDay(), 0, 0, 0, 0);
        }

        public boolean accept(Object o) {
            if (!(o instanceof ChatMessage)) {
                return false;
            }
            return !((ChatMessage)o).getHeader().getDate().before(this.m_cutoff);
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    private class SelectAllMessages
    implements Filter {
        public boolean accept(Object o) {
            return o instanceof ChatMessage;
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    private class SelectMessagesByNumber
    implements Filter {
        private Time m_first;
        private int m_number;

        public SelectMessagesByNumber(int number, SessionState state) {
            this.m_number = number;
            try {
                ChatChannel ch = ChatService.getChatChannel((String)state.getAttribute(ChatAction.STATE_CHANNEL_REF));
                List list = ch.getMessages(null, false);
                this.m_first = list.size() < number ? ((ChatMessage)list.get(list.size() - 1)).getHeader().getDate() : ((ChatMessage)list.get(number - 1)).getHeader().getDate();
            }
            catch (Exception e) {
                this.m_first = new Time(System.currentTimeMillis());
            }
        }

        public boolean accept(Object o) {
            if (!(o instanceof ChatMessage)) {
                return false;
            }
            return ((ChatMessage)o).getHeader().getDate().compareTo(this.m_first) >= 0;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.m_number;
        }
    }

    private class SelectMessagesByTime
    implements Filter {
        private int m_days = 0;
        private Time m_cutoff = null;

        public SelectMessagesByTime(int days) {
            this.m_days = days;
            this.m_cutoff = new Time(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        }

        public boolean accept(Object o) {
            if (!(o instanceof ChatMessage)) {
                return false;
            }
            return !((ChatMessage)o).getHeader().getDate().before(this.m_cutoff);
        }

        public String toString() {
            return this.getClass().getName() + " " + Integer.toString(this.m_days);
        }
    }
}

