// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type CreateRouteTableRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* 路由表所属的私有网络ID  */
    VpcId string `json:"vpcId"`

    /* 路由表名称，只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。  */
    RouteTableName string `json:"routeTableName"`

    /* 描述,​ 允许输入UTF-8编码下的全部字符，不超过256字符 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: 路由表所属的私有网络ID (Required)
 * param routeTableName: 路由表名称，只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateRouteTableRequest(
    regionId string,
    vpcId string,
    routeTableName string,
) *CreateRouteTableRequest {

	return &CreateRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        VpcId: vpcId,
        RouteTableName: routeTableName,
	}
}

/*
 * param regionId: Region ID (Required)
 * param vpcId: 路由表所属的私有网络ID (Required)
 * param routeTableName: 路由表名称，只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。 (Required)
 * param description: 描述,​ 允许输入UTF-8编码下的全部字符，不超过256字符 (Optional)
 */
func NewCreateRouteTableRequestWithAllParams(
    regionId string,
    vpcId string,
    routeTableName string,
    description *string,
) *CreateRouteTableRequest {

    return &CreateRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        VpcId: vpcId,
        RouteTableName: routeTableName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateRouteTableRequestWithoutParam() *CreateRouteTableRequest {

    return &CreateRouteTableRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *CreateRouteTableRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param vpcId: 路由表所属的私有网络ID(Required) */
func (r *CreateRouteTableRequest) SetVpcId(vpcId string) {
    r.VpcId = vpcId
}

/* param routeTableName: 路由表名称，只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符。(Required) */
func (r *CreateRouteTableRequest) SetRouteTableName(routeTableName string) {
    r.RouteTableName = routeTableName
}

/* param description: 描述,​ 允许输入UTF-8编码下的全部字符，不超过256字符(Optional) */
func (r *CreateRouteTableRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateRouteTableRequest) GetRegionId() string {
    return r.RegionId
}

type CreateRouteTableResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result CreateRouteTableResult `json:"result"`
}

type CreateRouteTableResult struct {
    RouteTableId string `json:"routeTableId"`
}