<?php declare(strict_types=1);
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PHPUnit\TestFixture\Metadata\Attribute;

use PHPUnit\Framework\Attributes\TestDox;
use PHPUnit\Framework\Attributes\TestDoxFormatter;
use PHPUnit\Framework\Attributes\TestDoxFormatterExternal;
use PHPUnit\Framework\TestCase;

#[TestDox('text')]
final class TestDoxTest extends TestCase
{
    #[TestDox('text')]
    public function testOne(): void
    {
    }

    #[TestDoxFormatter('methodName')]
    public function testTwo(): void
    {
    }

    #[TestDoxFormatterExternal('ClassName', 'methodName')]
    public function testThree(): void
    {
    }
}
