% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscript-loc.R
\name{vec_as_location}
\alias{vec_as_location}
\alias{num_as_location}
\alias{vec_as_location2}
\alias{num_as_location2}
\title{Create a vector of locations}
\usage{
vec_as_location(
  i,
  n,
  names = NULL,
  ...,
  missing = c("propagate", "remove", "error"),
  arg = caller_arg(i),
  call = caller_env()
)

num_as_location(
  i,
  n,
  ...,
  missing = c("propagate", "remove", "error"),
  negative = c("invert", "error", "ignore"),
  oob = c("error", "remove", "extend"),
  zero = c("remove", "error", "ignore"),
  arg = caller_arg(i),
  call = caller_env()
)

vec_as_location2(
  i,
  n,
  names = NULL,
  ...,
  missing = c("error", "propagate"),
  arg = caller_arg(i),
  call = caller_env()
)

num_as_location2(
  i,
  n,
  ...,
  negative = c("error", "ignore"),
  missing = c("error", "propagate"),
  arg = caller_arg(i),
  call = caller_env()
)
}
\arguments{
\item{i}{An index vector to convert.}

\item{n}{A single integer representing the total size of the
object that \code{i} is meant to index into.}

\item{names}{If \code{i} is a character vector, \code{names} should be a character
vector that \code{i} will be matched against to construct the index. Otherwise,
not used. The default value of \code{NULL} will result in an error
if \code{i} is a character vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{missing}{How should missing \code{i} values be handled?
\itemize{
\item \code{"error"} throws an error.
\item \code{"propagate"} returns them as is.
\item \code{"remove"} removes them.
}

By default, vector subscripts propagate missing values but scalar
subscripts error on them.

Propagated missing values can't be combined with negative indices when
\code{negative = "invert"}, because they can't be meaningfully inverted.}

\item{arg}{The argument name to be displayed in error messages.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{negative}{How should negative \code{i} values be handled?
\itemize{
\item \code{"error"} throws an error.
\item \code{"ignore"} returns them as is.
\item \code{"invert"} returns the positive location generated by inverting the
negative location. When inverting, positive and negative locations
can't be mixed. This option is only applicable for \code{num_as_location()}.
}}

\item{oob}{How should out-of-bounds \code{i} values be handled?
\itemize{
\item \code{"error"} throws an error.
\item \code{"remove"} removes both positive and negative out-of-bounds locations.
\item \code{"extend"} allows positive out-of-bounds locations if they directly
follow the end of a vector. This can be used to implement extendable
vectors, like \code{letters[1:30]}.
}}

\item{zero}{How should zero \code{i} values be handled?
\itemize{
\item \code{"error"} throws an error.
\item \code{"remove"} removes them.
\item \code{"ignore"} returns them as is.
}}
}
\value{
\itemize{
\item \code{vec_as_location()} and \code{num_as_location()} return an integer vector that
can be used as an index in a subsetting operation.
\item \code{vec_as_location2()} and \code{num_as_location2()} return an integer of size 1
that can be used a scalar index for extracting an element.
}
}
\description{
These helpers provide a means of standardizing common indexing
methods such as integer, character or logical indexing.
\itemize{
\item \code{vec_as_location()} accepts integer, character, or logical vectors
of any size. The output is always an integer vector that is
suitable for subsetting with \code{[} or \code{\link[=vec_slice]{vec_slice()}}. It might be a
different size than the input because negative selections are
transformed to positive ones and logical vectors are transformed
to a vector of indices for the \code{TRUE} locations.
\item \code{vec_as_location2()} accepts a single number or string. It returns
a single location as a integer vector of size 1. This is suitable
for extracting with \code{[[}.
\item \code{num_as_location()} and \code{num_as_location2()} are specialized variants
that have extra options for numeric indices.
}
}
\examples{
x <- array(1:6, c(2, 3))
dimnames(x) <- list(c("r1", "r2"), c("c1", "c2", "c3"))

# The most common use case validates row indices
vec_as_location(1, vec_size(x))

# Negative indices can be used to index from the back
vec_as_location(-1, vec_size(x))

# Character vectors can be used if `names` are provided
vec_as_location("r2", vec_size(x), rownames(x))

# You can also construct an index for dimensions other than the first
vec_as_location(c("c2", "c1"), ncol(x), colnames(x))

}
\keyword{internal}
