### AMD SMI

AMD SMI for ROCm 6.1.2

#### Additions

* Added process isolation and clean shader APIs and CLI commands.
  * `amdsmi_get_gpu_process_isolation()`
  * `amdsmi_set_gpu_process_isolation()`
  * `amdsmi_set_gpu_clear_sram_data()`
* Added the `MIN_POWER` metric to output provided by `amd-smi static --limit`.

#### Optimizations

* Updated the `amd-smi monitor --pcie` output to prevent delays with the `monitor` command.

#### Changes

* Updated `amismi_get_power_cap_info` to return values in uW instead of W.
* Updated Python library return types for `amdsmi_get_gpu_memory_reserved_pages` and `amdsmi_get_gpu_bad_page_info`.
* Updated the output of `amd-smi metric --ecc-blocks` to show counters available from blocks.

#### Fixes

* `amdsmi_get_gpu_board_info()` no longer returns junk character strings.
* `amd-smi metric --power` now correctly details power output for RDNA3, RDNA2, and MI1x devices.
* Fixed the `amdsmitstReadWrite.TestPowerCapReadWrite` test for RDNA3, RDNA2, and MI100 devices.
* Fixed an issue with the `amdsmi_get_gpu_memory_reserved_pages` and `amdsmi_get_gpu_bad_page_info` Python interface calls.

#### Removals

* Removed the `amdsmi_get_gpu_process_info` API from the Python library. It was removed from the C library in an earlier release.

```{note}
See the AMD SMI [detailed changelog](https://github.com/ROCm/amdsmi/blob/rocm-6.1.x/CHANGELOG.md) with code samples for more information.
```

### ROCm SMI

ROCm SMI for ROCm 6.1.2

#### Additions

* Added the ring hang event to the `amdsmi_evt_notification_type_t` enum.

#### Fixes

* Fixed an issue causing ROCm SMI to incorrectly report GPU utilization for RDNA3 GPUs. See the issue on [GitHub](https://github.com/ROCm/ROCm/issues/3112).
* Fixed the parsing of `pp_od_clk_voltage` in `get_od_clk_volt_info` to work better with MI-series hardware.
