/*
 * Copyright (C) 2000-2024 the xine project
 *
 * This file is part of xine, a free video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 * video window handling functions
 */

#ifndef VIDEOWIN_H
#define VIDEOWIN_H

typedef int vwin_mag_t;
#define VWIN_MAG_LD 16
#define VWIN_MAG_1 (1 << VWIN_MAG_LD)

#define CURSOR_ARROW               1
#define CURSOR_HAND                2

xui_vwin_t *video_window_init (gGui_t *gui, int window_id, int borderless, const char *geometry,
                               int hide_on_start, const char *prefered_visual, int install_colormap,
                               int use_x_lock_display);
void video_window_exit (xui_vwin_t *vwin);

void *video_window_get_xine_visual(xui_vwin_t *vwin, int *visual_type);

void video_window_select_visual (xui_vwin_t *vwin);

/* set/check fullscreen mode */
#define WINDOWED_MODE   1
#define FULLSCR_MODE    2
#define FULLSCR_XI_MODE 4
#define BORDER_MODE     8
#define TOGGLE_MODE    16
uint32_t video_window_mode (xui_vwin_t *vwin, uint32_t mode_flags);

/* Set cursor */
void video_window_set_cursor (xui_vwin_t *vwin, int cursor);
/* hide/show cursor in video window*/
void video_window_set_cursor_visibility (xui_vwin_t *vwin, int show_cursor);

/* hide/show video window */
void video_window_set_visibility (xui_vwin_t *vwin, int show_window);
/* NOTE: return 0 (unmapped), 1 (iconified), 2 (visible) */
int video_window_is_visible (xui_vwin_t *vwin);
int video_window_is_separate_display(xui_vwin_t *vwin);

/** negative value multiplys with previous one. return new value or 0 on error. */
vwin_mag_t video_window_set_mag (xui_vwin_t *vwin, vwin_mag_t mag);

/** suspend = 1 (playing), 0 (paused/logo). */
long int video_window_reset_ssaver (xui_vwin_t *vwin, int suspend);

#define VWIN_SIZE_FRAME 1
#define VWIN_SIZE_VISIBLE 2
#define VWIN_SIZE_OUTPUT 3
void video_window_get_size (xui_vwin_t *vwin, int size[2], int what);

void video_window_set_mrl (xui_vwin_t *vwin, const char *mrl);

void video_window_set_transient_for (xui_vwin_t *vwin, xitk_window_t *xwin);

/* void video_window_set_input_focus(xui_vwin_t *vwin); */
void video_window_grab_input_focus(xui_vwin_t *vwin);

void video_window_grab_pointer (xui_vwin_t *vwin, int grab);

#endif
